/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import io.crate.common.collections.PeekingIterator;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Iterators {
    private Iterators() {
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> inputs) {
        return new ConcatenatedIterator(inputs);
    }

    @SafeVarargs
    public static final <T> Iterator<T> concat(Iterator<? extends T> ... inputs) {
        return Iterators.concatNoDefensiveCopy(Arrays.copyOf(inputs, inputs.length));
    }

    @SafeVarargs
    static final <T> Iterator<T> concatNoDefensiveCopy(Iterator<? extends T> ... inputs) {
        for (Iterator<? extends T> input : Objects.requireNonNull(inputs)) {
            Objects.requireNonNull(input);
        }
        return Iterators.concat(Iterators.consumingForArray((Iterator[])inputs));
    }

    @SafeVarargs
    private static final <I extends Iterator<?>> Iterator<I> consumingForArray(I ... elements) {
        return new Iterator<I>((Iterator[])elements){
            int index = 0;
            final /* synthetic */ Iterator[] val$elements;
            {
                this.val$elements = iteratorArray;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.val$elements.length;
            }

            @Override
            public I next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator result = Objects.requireNonNull(this.val$elements[this.index]);
                this.val$elements[this.index] = null;
                ++this.index;
                return result;
            }
        };
    }

    public static <T> Iterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> comparator) {
        Objects.requireNonNull(iterators, "iterators");
        Objects.requireNonNull(comparator, "comparator");
        return new MergingIterator<T>(iterators, comparator);
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder().append("expected one element but was: <").append(first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    @Nullable
    public static <T> T getNext(Iterator<? extends T> iterator, @Nullable T defaultValue) {
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    @Nullable
    public static <T> T getLast(Iterator<? extends T> iterator, @Nullable T defaultValue) {
        return iterator.hasNext() ? Iterators.getLast(iterator) : defaultValue;
    }

    public static <T> Iterator<List<T>> partition(Iterator<T> iterator, int size) {
        return Iterators.partitionImpl(iterator, size, false);
    }

    private static <T> Iterator<List<T>> partitionImpl(final Iterator<T> iterator, final int size, final boolean pad) {
        Objects.requireNonNull(iterator);
        assert (size > 0);
        return new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public List<T> next() {
                int count;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] array = new Object[size];
                for (count = 0; count < size && iterator.hasNext(); ++count) {
                    array[count] = iterator.next();
                }
                for (int i = count; i < size; ++i) {
                    array[i] = null;
                }
                List<Object> list = Collections.unmodifiableList(Arrays.asList(array));
                return pad || count == size ? list : list.subList(0, count);
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        if (iterator instanceof PeekingImpl) {
            PeekingImpl peeking = (PeekingImpl)iterator;
            return peeking;
        }
        return new PeekingImpl<T>(iterator);
    }

    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> function) {
        Objects.requireNonNull(function);
        return new TransformedIterator<F, T>(fromIterator, function);
    }

    static <A, B> Spliterator<B> map(final Spliterator<A> fromSpliterator, final Function<? super A, ? extends B> function) {
        Objects.requireNonNull(fromSpliterator);
        Objects.requireNonNull(function);
        return new Spliterator<B>(){

            @Override
            public boolean tryAdvance(Consumer<? super B> action) {
                return fromSpliterator.tryAdvance((? super T fromElement) -> action.accept((Object)function.apply(fromElement)));
            }

            @Override
            public void forEachRemaining(Consumer<? super B> action) {
                fromSpliterator.forEachRemaining((? super T fromElement) -> action.accept((Object)function.apply(fromElement)));
            }

            @Override
            public Spliterator<B> trySplit() {
                Spliterator fromSplit = fromSpliterator.trySplit();
                return fromSplit != null ? Iterators.map(fromSplit, function) : null;
            }

            @Override
            public long estimateSize() {
                return fromSpliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return fromSpliterator.characteristics() & 0xFFFFFEFA;
            }
        };
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        Objects.requireNonNull(addTo);
        Objects.requireNonNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        @Nullable
        private Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = Collections.emptyIterator();
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        @Nullable
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> metaIterator) {
            this.topMetaIterator = Objects.requireNonNull(metaIterator);
        }

        @Nullable
        private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
                if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                    this.topMetaIterator = this.metaIterators.removeFirst();
                    continue;
                }
                return null;
            }
            return this.topMetaIterator;
        }

        @Override
        public boolean hasNext() {
            while (!Objects.requireNonNull(this.iterator).hasNext()) {
                this.topMetaIterator = this.getTopMetaIterator();
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator topConcat = (ConcatenatedIterator)this.iterator;
                this.iterator = topConcat.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (topConcat.metaIterators != null) {
                    while (!topConcat.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(topConcat.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = topConcat.topMetaIterator;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }
    }

    private static class MergingIterator<T>
    implements Iterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterators, final Comparator<? super T> itemComparator) {
            Comparator heapComparator = new Comparator<PeekingIterator<T>>(){

                @Override
                public int compare(PeekingIterator<T> o1, PeekingIterator<T> o2) {
                    return itemComparator.compare(o1.peek(), o2.peek());
                }
            };
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, heapComparator);
            for (Iterator<T> iterator : iterators) {
                if (!iterator.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(iterator));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            PeekingIterator<T> nextIter = this.queue.remove();
            T next = nextIter.next();
            if (nextIter.hasNext()) {
                this.queue.add(nextIter);
            }
            return next;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        @Nullable
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E result = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return result;
        }

        @Override
        public void remove() {
            assert (!this.hasPeeked) : "Can't remove after you've peeked at next";
            this.iterator.remove();
        }

        @Override
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }
    }

    private static class TransformedIterator<F, T>
    implements Iterator<T> {
        final Iterator<? extends F> backingIterator;
        final Function<? super F, ? extends T> function;

        TransformedIterator(Iterator<? extends F> backingIterator, Function<? super F, ? extends T> function) {
            this.backingIterator = Objects.requireNonNull(backingIterator);
            this.function = function;
        }

        public T transform(F from) {
            return this.function.apply(from);
        }

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final T next() {
            return this.transform(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }

    static abstract class AbstractIndexedListIterator<E>
    implements ListIterator<E> {
        private final int size;
        private int position;

        protected abstract E get(int var1);

        protected AbstractIndexedListIterator(int size) {
            this(size, 0);
        }

        protected AbstractIndexedListIterator(int size, int position) {
            Objects.checkIndex(position, size);
            this.size = size;
            this.position = position;
        }

        @Override
        public final boolean hasNext() {
            return this.position < this.size;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.get(this.position++);
        }

        @Override
        public final int nextIndex() {
            return this.position;
        }

        @Override
        public final boolean hasPrevious() {
            return this.position > 0;
        }

        @Override
        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.get(--this.position);
        }

        @Override
        public final int previousIndex() {
            return this.position - 1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void set(E e) {
            throw new UnsupportedOperationException("set");
        }

        @Override
        public final void add(E e) {
            throw new UnsupportedOperationException("add");
        }
    }
}

