/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import io.crate.common.StringUtils;
import io.crate.common.TriConsumer;
import io.crate.common.collections.Lists;
import io.crate.common.collections.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.RandomAccess;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class Maps {
    public static <K, V> Map<K, V> concat(Map<K, V> m1, Map<K, V> m2) {
        if (m1.isEmpty()) {
            return m2;
        }
        if (m2.isEmpty()) {
            return m1;
        }
        HashMap<K, V> result = new HashMap<K, V>();
        result.putAll(m1);
        result.putAll(m2);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> merge(Map<K, V> m1, Map<K, V> m2, BiFunction<V, V, V> mergeValues) {
        if (m1.isEmpty()) {
            return m2;
        }
        if (m2.isEmpty()) {
            return m1;
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> m1Entry : m1.entrySet()) {
            K m1Key = m1Entry.getKey();
            V m1Values = m1Entry.getValue();
            V m2Values = m2.get(m1Key);
            if (m1Values != null && m2Values != null) {
                result.put(m1Key, mergeValues.apply(m1Values, m2Values));
                continue;
            }
            if (m1Values != null) {
                result.put(m1Key, m1Values);
                continue;
            }
            if (m2Values == null) continue;
            result.put(m1Key, m2Values);
        }
        for (Map.Entry<K, V> key : Sets.difference(m2.keySet(), result.keySet())) {
            result.put(key, m2.get(key));
        }
        return result;
    }

    public static <T> T get(Map<String, ?> map, String key) {
        return (T)map.get(key);
    }

    public static <T> T getOrDefault(@Nullable Map<String, Object> map, String key, T defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        return (T)map.getOrDefault(key, defaultValue);
    }

    @Nullable
    public static Object getByPath(Map<String, Object> map, String path) {
        assert (path != null) : "path should not be null";
        return Maps.getByPath(map, StringUtils.splitToList('.', path));
    }

    @Nullable
    public static Object getByPath(Map<?, ?> value, List<String> path) {
        return Maps.getByPath(value, path, 0);
    }

    private static Object getByPath(Map<?, ?> value, List<String> path, int startIndex) {
        assert (path instanceof RandomAccess) : "Path must support random access for fast iteration";
        Map map = value;
        for (int i = startIndex; i < path.size(); ++i) {
            Map m;
            String key = path.get(i);
            Object val = map.get(key);
            if (i + 1 == path.size()) {
                return val;
            }
            if (!(val instanceof Map)) {
                if (val instanceof List) {
                    List list = (List)val;
                    return Maps.getByPath(list, path, i);
                }
                return null;
            }
            map = m = (Map)val;
        }
        return map;
    }

    private static Object getByPath(List<?> list, List<String> path, int startIndex) {
        if (startIndex + 1 == path.size()) {
            return list;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object o : list) {
            if (o instanceof Map) {
                Map m = (Map)o;
                newList.add(Maps.getByPath(m, path, startIndex + 1));
                continue;
            }
            if (o instanceof List) {
                List l = (List)o;
                newList.add(Maps.getByPath(l, path, startIndex));
                continue;
            }
            newList.add(o);
        }
        return newList;
    }

    @Nullable
    public static <T> T removeByPath(Map<String, T> map, List<String> path) {
        assert (path instanceof RandomAccess) : "`path` must support random access for performance";
        Map m = map;
        for (int i = 0; i < path.size(); ++i) {
            String key = path.get(i);
            if (i + 1 == path.size()) {
                return m.remove(key);
            }
            T val = map.get(key);
            if (!(val instanceof Map)) {
                return null;
            }
            m = (Map)val;
        }
        return null;
    }

    public static void mergeInto(Map<String, Object> source, String key, List<String> path, Object value) {
        Maps.mergeInto(source, key, path, value, Map::put);
    }

    public static void mergeInto(Map<String, Object> source, String key, List<String> path, Object value, TriConsumer<Map<String, Object>, String, Object> writer) {
        if (path.isEmpty()) {
            writer.accept(source, key, value);
        } else if (source.containsKey(key)) {
            HashMap<String, Object> contents = (HashMap<String, Object>)source.get(key);
            if (contents == null) {
                contents = new HashMap<String, Object>();
                source.put(key, contents);
            }
            String nextKey = path.get(0);
            Maps.mergeInto(contents, nextKey, path.subList(1, path.size()), value, writer);
        } else {
            writer.accept(source, key, Maps.nestedMaps(path, value));
        }
    }

    private static Map<String, Object> nestedMaps(List<String> path, Object value) {
        HashMap<String, Object> root;
        HashMap<String, Object> m = root = new HashMap<String, Object>(1);
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            String key = path.get(i);
            if (i + 1 == size) {
                m.put(key, value);
                continue;
            }
            HashMap nextChild = new HashMap(1);
            m.put(key, nextChild);
            m = nextChild;
        }
        return root;
    }

    public static void extendRecursive(Map<String, Object> map, Map<String, Object> additions) {
        Maps.extendRecursive(map, additions, (oldList, newList) -> Lists.concatUnique(oldList, newList));
    }

    public static void extendRecursive(Map<String, Object> map, Map<String, Object> additions, BiFunction<List<Object>, Collection<Object>, List<Object>> mergeLists) {
        for (Map.Entry<String, Object> additionEntry : additions.entrySet()) {
            String key = additionEntry.getKey();
            Object addition = additionEntry.getValue();
            if (map.containsKey(key)) {
                Object sourceValue = map.get(key);
                if (sourceValue instanceof Map && addition instanceof Map) {
                    Maps.extendRecursive((Map)sourceValue, (Map)addition);
                }
                if (!(sourceValue instanceof List) || !(addition instanceof Collection)) continue;
                map.put(key, mergeLists.apply((List)sourceValue, (List)addition));
                continue;
            }
            map.put(key, addition);
        }
    }

    public static <K, V> Map<K, V> uniqueIndex(Iterable<V> values, Function<? super V, K> keyFunction) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (V value : values) {
            K key = keyFunction.apply(value);
            Object previous = result.put(key, value);
            if (previous == null) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Duplicated value %s for key %s", previous, key));
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> V putNonNull(Map<K, V> map, K key, @Nullable V value) {
        if (value != null) {
            return map.put(key, value);
        }
        return null;
    }
}

