/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import io.crate.common.collections.AbstractIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Sets {
    private Sets() {
    }

    public static <T> Set<T> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <T> boolean haveEmptyIntersection(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return left.stream().noneMatch(right::contains);
    }

    @SafeVarargs
    public static <T> Set<T> concat(Set<T> left, T ... right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        HashSet<T> result = new HashSet<T>(left);
        result.addAll(List.of(right));
        return Collections.unmodifiableSet(result);
    }

    public static <T> Set<T> union(Collection<T> left, Collection<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        HashSet<T> union = new HashSet<T>(left);
        union.addAll(right);
        return union;
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        Set<T> right;
        Set<T> left;
        Objects.requireNonNull(set1);
        Objects.requireNonNull(set2);
        if (set1.size() < set2.size()) {
            left = set1;
            right = set2;
        } else {
            left = set2;
            right = set1;
        }
        return left.stream().filter(right::contains).collect(Collectors.toSet());
    }

    public static <E> Set<E> difference(final Set<E> set1, final Set<?> set2) {
        Objects.requireNonNull(set1, "set1");
        Objects.requireNonNull(set2, "set2");
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set1.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e = this.itr.next();
                            if (set2.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set1.stream().filter(e -> !set2.contains(e));
            }

            @Override
            public Stream<E> parallelStream() {
                return set1.parallelStream().filter(e -> !set2.contains(e));
            }

            @Override
            public int size() {
                int size = 0;
                for (Object e : set1) {
                    if (set2.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set1);
            }

            @Override
            public boolean contains(Object element) {
                return set1.contains(element) && !set2.contains(element);
            }
        };
    }
}

