/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.concurrent;

import io.crate.common.concurrent.Killable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class KillableCompletionStage<T>
implements CompletionStage<T>,
Killable {
    private final CompletionStage<T> delegate;
    private final Consumer<Throwable> onKill;

    public static <T> KillableCompletionStage<T> whenKilled(CompletionStage<T> delegate, Consumer<Throwable> onKill) {
        return new KillableCompletionStage<T>(delegate, onKill);
    }

    public static <T> KillableCompletionStage<T> failed(Throwable t) {
        return new KillableCompletionStage(CompletableFuture.failedFuture(t), ignored -> {});
    }

    private KillableCompletionStage(CompletionStage<T> delegate, Consumer<Throwable> onKill) {
        this.delegate = delegate;
        this.onKill = onKill;
    }

    @Override
    public void kill(@NotNull Throwable throwable) {
        this.onKill.accept(throwable);
    }

    @Override
    public <U> KillableCompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.thenApply(fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.thenApplyAsync(fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.thenApplyAsync(fn, executor), this.onKill);
    }

    public KillableCompletionStage<Void> thenAccept(Consumer<? super T> action) {
        return KillableCompletionStage.whenKilled(this.delegate.thenAccept(action), this.onKill);
    }

    public KillableCompletionStage<Void> thenAcceptAsync(Consumer<? super T> action) {
        return KillableCompletionStage.whenKilled(this.delegate.thenAcceptAsync(action), this.onKill);
    }

    public KillableCompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.thenAcceptAsync(action, executor), this.onKill);
    }

    public KillableCompletionStage<Void> thenRun(Runnable action) {
        return KillableCompletionStage.whenKilled(this.delegate.thenRun(action), this.onKill);
    }

    public KillableCompletionStage<Void> thenRunAsync(Runnable action) {
        return KillableCompletionStage.whenKilled(this.delegate.thenRunAsync(action), this.onKill);
    }

    public KillableCompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.thenRunAsync(action, executor), this.onKill);
    }

    @Override
    public <U, V> KillableCompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.thenCombine(other, fn), this.onKill);
    }

    @Override
    public <U, V> KillableCompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.thenCombineAsync(other, fn), this.onKill);
    }

    @Override
    public <U, V> KillableCompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.thenCombineAsync(other, fn, executor), this.onKill);
    }

    public <U> KillableCompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return KillableCompletionStage.whenKilled(this.delegate.thenAcceptBoth(other, action), this.onKill);
    }

    public <U> KillableCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return KillableCompletionStage.whenKilled(this.delegate.thenAcceptBothAsync(other, action), this.onKill);
    }

    public <U> KillableCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.thenAcceptBothAsync(other, action, executor), this.onKill);
    }

    public KillableCompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return KillableCompletionStage.whenKilled(this.delegate.runAfterBoth(other, action), this.onKill);
    }

    public KillableCompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return KillableCompletionStage.whenKilled(this.delegate.runAfterBothAsync(other, action), this.onKill);
    }

    public KillableCompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.runAfterBothAsync(other, action, executor), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.applyToEither(other, fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.applyToEitherAsync(other, fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.applyToEitherAsync(other, fn, executor), this.onKill);
    }

    public KillableCompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return KillableCompletionStage.whenKilled(this.delegate.acceptEither(other, action), this.onKill);
    }

    public KillableCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return KillableCompletionStage.whenKilled(this.delegate.acceptEitherAsync(other, action), this.onKill);
    }

    public KillableCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.acceptEitherAsync(other, action, executor), this.onKill);
    }

    public KillableCompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return KillableCompletionStage.whenKilled(this.delegate.runAfterEither(other, action), this.onKill);
    }

    public KillableCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return KillableCompletionStage.whenKilled(this.delegate.runAfterEitherAsync(other, action), this.onKill);
    }

    public KillableCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.runAfterEitherAsync(other, action, executor), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.thenCompose(fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.thenComposeAsync(fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.thenComposeAsync(fn, executor), this.onKill);
    }

    @Override
    public KillableCompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return KillableCompletionStage.whenKilled(this.delegate.whenComplete(action), this.onKill);
    }

    @Override
    public KillableCompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return KillableCompletionStage.whenKilled(this.delegate.whenCompleteAsync(action), this.onKill);
    }

    @Override
    public KillableCompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.whenCompleteAsync(action, executor), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.handle(fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.handleAsync(fn), this.onKill);
    }

    @Override
    public <U> KillableCompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return KillableCompletionStage.whenKilled(this.delegate.handleAsync(fn, executor), this.onKill);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.delegate.toCompletableFuture();
    }

    @Override
    public KillableCompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return KillableCompletionStage.whenKilled(this.delegate.exceptionally(fn), this.onKill);
    }
}

