/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.jetbrains.annotations.Nullable;

public class XContentFactory {
    public static XContentBuilder json(OutputStream os) throws IOException {
        return XContentFactory.json(os, null);
    }

    public static XContentBuilder json(OutputStream os, @Nullable String rootValueSeparator) throws IOException {
        return new XContentBuilder(JsonXContent.JSON_XCONTENT, os, rootValueSeparator);
    }

    public static XContentBuilder smile(OutputStream os) throws IOException {
        return new XContentBuilder(SmileXContent.SMILE_XCONTENT, os);
    }

    public static XContentBuilder yaml(OutputStream os) throws IOException {
        return new XContentBuilder(YamlXContent.YAML_XCONTENT, os);
    }

    public static XContentBuilder builder(XContentType type, OutputStream outputStream) throws IOException {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case XContentType.JSON -> new XContentBuilder(JsonXContent.JSON_XCONTENT, outputStream);
            case XContentType.SMILE -> new XContentBuilder(SmileXContent.SMILE_XCONTENT, outputStream);
            case XContentType.YAML -> new XContentBuilder(YamlXContent.YAML_XCONTENT, outputStream);
        };
    }
}

