/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.parser;

import io.crate.protocols.postgres.antlr.PgArrayBaseVisitor;
import io.crate.protocols.postgres.antlr.PgArrayParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

class PgArrayASTVisitor
extends PgArrayBaseVisitor<Object> {
    private final Function<byte[], Object> convert;

    PgArrayASTVisitor(Function<byte[], Object> convert) {
        this.convert = convert;
    }

    @Override
    public Object visitArray(PgArrayParser.ArrayContext ctx) {
        List<PgArrayParser.ItemContext> items = ctx.item();
        ArrayList<Object> result = new ArrayList<Object>(items.size());
        for (PgArrayParser.ItemContext item : items) {
            result.add(item.accept(this));
        }
        return result;
    }

    @Override
    public Object visitUnquotedString(PgArrayParser.UnquotedStringContext ctx) {
        String text = ctx.getText();
        return this.convert.apply(text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Object visitNull(PgArrayParser.NullContext ctx) {
        return null;
    }

    @Override
    public Object visitQuotedString(PgArrayParser.QuotedStringContext ctx) {
        String text = ctx.getText();
        String withoutQuotes = text.substring(1, text.length() - 1);
        return this.convert.apply(PgArrayASTVisitor.removeEscapes(withoutQuotes.getBytes(StandardCharsets.UTF_8)));
    }

    private static byte[] removeEscapes(byte[] bytes) {
        byte[] itemBytes = new byte[bytes.length];
        int elementsCount = 0;
        int end = bytes.length - 1;
        for (int i = 0; i <= end; ++i) {
            char c = (char)bytes[i];
            if (i < end) {
                char next = (char)bytes[i + 1];
                if (c == '\\' && (next == '\\' || next == '\"')) {
                    ++i;
                }
            }
            itemBytes[elementsCount++] = bytes[i];
        }
        return Arrays.copyOf(itemBytes, elementsCount);
    }
}

