/*
 * Decompiled with CFR 0.152.
 */
package io.crate.window;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.Nullable;

public class NthValueFunctions
implements WindowFunction {
    public static final String FIRST_VALUE_NAME = "first_value";
    public static final String LAST_VALUE_NAME = "last_value";
    public static final String NTH_VALUE_NAME = "nth_value";
    private final Implementation implementation;
    private final Signature signature;
    private final BoundSignature boundSignature;
    private int seenFrameLowerBound = -1;
    private int seenFrameUpperBound = -1;
    private Object resultForCurrentFrame = null;

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder((String)FIRST_VALUE_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E")}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new NthValueFunctions((Signature)signature, (BoundSignature)boundSignature, Implementation.FIRST_VALUE));
        builder.add(Signature.builder((String)LAST_VALUE_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E")}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new NthValueFunctions((Signature)signature, (BoundSignature)boundSignature, Implementation.LAST_VALUE));
        builder.add(Signature.builder((String)NTH_VALUE_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E"), DataTypes.INTEGER.getTypeSignature()}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new NthValueFunctions((Signature)signature, (BoundSignature)boundSignature, Implementation.NTH_VALUE));
    }

    private NthValueFunctions(Signature signature, BoundSignature boundSignature, Implementation implementation) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.implementation = implementation;
    }

    public Signature signature() {
        return this.signature;
    }

    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    public Object execute(LongConsumer allocateBytes, int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, @Nullable Boolean ignoreNulls, Input<?> ... args) {
        boolean ignoreNullsOrFalse = ignoreNulls != null && ignoreNulls != false;
        boolean shrinkingWindow = WindowFrameState.isLowerBoundIncreasing((WindowFrameState)currentFrame, (int)this.seenFrameLowerBound);
        if (idxInPartition == 0 || currentFrame.upperBoundExclusive() > this.seenFrameUpperBound || shrinkingWindow) {
            int adjustForShrinkingWindow = 0;
            if (shrinkingWindow) {
                adjustForShrinkingWindow = currentFrame.lowerBound();
            }
            this.resultForCurrentFrame = this.implementation.execute(adjustForShrinkingWindow, currentFrame, expressions, ignoreNullsOrFalse, args);
            this.seenFrameLowerBound = currentFrame.lowerBound();
            this.seenFrameUpperBound = currentFrame.upperBoundExclusive();
        }
        return this.resultForCurrentFrame;
    }

    private static enum Implementation {
        FIRST_VALUE{

            @Override
            public Object execute(int adjustForShrinkingWindow, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, boolean ignoreNulls, Input<?> ... args) {
                if (ignoreNulls) {
                    for (int i = adjustForShrinkingWindow; i < currentFrame.upperBoundExclusive(); ++i) {
                        Object value;
                        Object[] nthRowCells = currentFrame.getRowInFrameAtIndexOrNull(i);
                        if (nthRowCells == null || (value = 1.extractValueFromRow(nthRowCells, expressions, args)) == null) continue;
                        return value;
                    }
                } else {
                    return 1.extractValueAtIndex(adjustForShrinkingWindow, currentFrame, expressions, args);
                }
                return null;
            }
        }
        ,
        LAST_VALUE{

            @Override
            public Object execute(int adjustForShrinkingWindow, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, boolean ignoreNulls, Input<?> ... args) {
                if (ignoreNulls) {
                    for (int i = adjustForShrinkingWindow + currentFrame.size() - 1; i >= 0; --i) {
                        Object value;
                        Object[] nthRowCells = currentFrame.getRowInFrameAtIndexOrNull(i);
                        if (nthRowCells == null || (value = 2.extractValueFromRow(nthRowCells, expressions, args)) == null) continue;
                        return value;
                    }
                } else {
                    return 2.extractValueAtIndex(adjustForShrinkingWindow + currentFrame.size() - 1, currentFrame, expressions, args);
                }
                return null;
            }
        }
        ,
        NTH_VALUE{

            @Override
            public Object execute(int adjustForShrinkingWindow, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, boolean ignoreNulls, Input<?> ... args) {
                Number position = (Number)args[1].value();
                if (position == null) {
                    return null;
                }
                int iPosition = position.intValue();
                if (ignoreNulls) {
                    int counter = 0;
                    for (int i = adjustForShrinkingWindow; i < currentFrame.upperBoundExclusive(); ++i) {
                        Object value;
                        Object[] nthRowCells = currentFrame.getRowInFrameAtIndexOrNull(i);
                        if (nthRowCells == null || (value = 3.extractValueFromRow(nthRowCells, expressions, args)) == null || ++counter != iPosition) continue;
                        return value;
                    }
                } else {
                    return 3.extractValueAtIndex(adjustForShrinkingWindow + iPosition - 1, currentFrame, expressions, args);
                }
                return null;
            }
        };


        public abstract Object execute(int var1, WindowFrameState var2, List<? extends CollectExpression<Row, ?>> var3, boolean var4, Input<?> ... var5);

        protected static Object extractValueFromRow(Object[] nthRowCells, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
            RowN nthRowInFrame = new RowN(nthRowCells);
            for (CollectExpression<Row, ?> expression : expressions) {
                expression.setNextRow((Object)nthRowInFrame);
            }
            return args[0].value();
        }

        protected static Object extractValueAtIndex(int index, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
            Object[] nthRowCells = currentFrame.getRowInFrameAtIndexOrNull(index);
            if (nthRowCells == null) {
                return null;
            }
            return Implementation.extractValueFromRow(nthRowCells, expressions, args);
        }
    }
}

