/*
 * Decompiled with CFR 0.152.
 */
package io.crate.window;

import com.carrotsearch.hppc.IntObjectHashMap;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.UnsafeArrayRow;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.Nullable;

public class OffsetValueFunctions
implements WindowFunction {
    private static final String LAG_NAME = "lag";
    private static final String LEAD_NAME = "lead";
    private static final int LAG_DEFAULT_OFFSET = -1;
    private static final int LEAD_DEFAULT_OFFSET = 1;
    private final int directionMultiplier;
    private final Signature signature;
    private final BoundSignature boundSignature;
    private Integer cachedOffset;
    private int resolvedDirection;
    private int cachedNonNullIndex;
    private IntObjectHashMap<Object[]> indexToRow;
    private final UnsafeArrayRow sharedRow = new UnsafeArrayRow();

    private Object getValueAtOffsetIgnoringNulls(LongConsumer allocateBytes, int idxInPartition, int offset, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
        if (this.cachedNonNullIndex == -1) {
            this.cachedNonNullIndex = this.findNonNullOffsetFromCurrentIndex(allocateBytes, idxInPartition, offset, currentFrame, expressions, args);
        } else if (this.resolvedDirection > 0) {
            Object curValue = this.getValueAtTargetIndex(allocateBytes, idxInPartition, currentFrame, expressions, args);
            if (curValue != null) {
                this.moveCacheToNextNonNull(allocateBytes, currentFrame, expressions, args);
            }
        } else {
            Object prevValue = this.getValueAtTargetIndex(allocateBytes, idxInPartition - 1, currentFrame, expressions, args);
            if (prevValue != null) {
                this.moveCacheToNextNonNull(allocateBytes, currentFrame, expressions, args);
            }
        }
        return this.getValueAtTargetIndex(allocateBytes, this.cachedNonNullIndex, currentFrame, expressions, args);
    }

    private void moveCacheToNextNonNull(LongConsumer allocateBytes, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
        if (this.cachedNonNullIndex == -1) {
            return;
        }
        for (int i = this.cachedNonNullIndex + 1; i <= currentFrame.partitionEnd(); ++i) {
            if (i == currentFrame.partitionEnd()) {
                this.cachedNonNullIndex = -1;
                break;
            }
            Object value = this.getValueAtTargetIndex(allocateBytes, i, currentFrame, expressions, args);
            if (value == null) continue;
            this.cachedNonNullIndex = i;
            break;
        }
    }

    private int findNonNullOffsetFromCurrentIndex(LongConsumer allocateBytes, int idxInPartition, int offset, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
        int i = 1;
        int counter = 0;
        Object value;
        while ((value = this.getValueAtTargetIndex(allocateBytes, this.getTargetIndex(idxInPartition, i), currentFrame, expressions, args)) == null || ++counter != offset) {
            ++i;
        }
        return this.getTargetIndex(idxInPartition, i);
    }

    private Object getValueAtOffset(LongConsumer allocateBytes, int idxAtPartition, int offset, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, boolean ignoreNulls, Input<?> ... args) {
        if (!ignoreNulls) {
            int targetIndex = this.getTargetIndex(idxAtPartition, offset);
            return this.getValueAtTargetIndex(allocateBytes, targetIndex, currentFrame, expressions, args);
        }
        if (offset == 0) {
            throw new IllegalArgumentException("offset 0 is not a valid argument if ignore nulls flag is set");
        }
        return this.getValueAtOffsetIgnoringNulls(allocateBytes, idxAtPartition, offset, currentFrame, expressions, args);
    }

    private Object getValueAtTargetIndex(LongConsumer allocateBytes, int targetIndex, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
        if (targetIndex == -1) {
            throw new IndexOutOfBoundsException();
        }
        Object[] row = (Object[])this.indexToRow.get(targetIndex);
        if (row == null) {
            row = currentFrame.getRowInPartitionAtIndexOrNull(targetIndex);
            if (row == null) {
                throw new IndexOutOfBoundsException();
            }
            long ramBytesPrev = this.indexToRow.ramBytesUsed();
            this.indexToRow.put(targetIndex, (Object)row);
            long deltaUsed = this.indexToRow.ramBytesUsed() - ramBytesPrev;
            if (deltaUsed > 0L) {
                allocateBytes.accept(deltaUsed);
            }
        }
        this.sharedRow.cells(row);
        for (CollectExpression<Row, ?> expression : expressions) {
            expression.setNextRow((Object)this.sharedRow);
        }
        return args[0].value();
    }

    private int getTargetIndex(int idxInPartition, int offset) {
        return idxInPartition + offset * this.resolvedDirection;
    }

    private OffsetValueFunctions(Signature signature, BoundSignature boundSignature, int directionMultiplier) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.directionMultiplier = directionMultiplier;
    }

    public Signature signature() {
        return this.signature;
    }

    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(LongConsumer allocateBytes, int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, @Nullable Boolean ignoreNulls, Input<?> ... args) {
        int offset;
        boolean ignoreNullsOrFalse;
        boolean bl = ignoreNullsOrFalse = ignoreNulls != null && ignoreNulls != false;
        if (args.length > 1) {
            Object offsetValue = args[1].value();
            if (offsetValue == null) return null;
            offset = ((Number)offsetValue).intValue();
        } else {
            offset = 1;
        }
        if (idxInPartition == 0) {
            this.indexToRow = new IntObjectHashMap(currentFrame.size());
            allocateBytes.accept(this.indexToRow.ramBytesAllocated());
        }
        if (idxInPartition == 0 || this.cachedOffset != null && this.cachedOffset != offset) {
            if (offset != 0) {
                this.resolvedDirection = offset / Math.abs(offset) * this.directionMultiplier;
            }
            this.cachedNonNullIndex = -1;
        }
        this.cachedOffset = offset;
        int cachedOffsetMagnitude = Math.abs(this.cachedOffset);
        try {
            return this.getValueAtOffset(allocateBytes, idxInPartition, cachedOffsetMagnitude, currentFrame, expressions, ignoreNullsOrFalse, args);
        }
        catch (IndexOutOfBoundsException e) {
            return OffsetValueFunctions.getDefaultOrNull(args);
        }
    }

    private static Object getDefaultOrNull(Input<?> ... args) {
        if (args.length == 3) {
            return args[2].value();
        }
        return null;
    }

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder((String)LEAD_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E")}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (BoundSignature)boundSignature, 1));
        builder.add(Signature.builder((String)LEAD_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E"), DataTypes.INTEGER.getTypeSignature()}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (BoundSignature)boundSignature, 1));
        builder.add(Signature.builder((String)LEAD_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parse((String)"E")}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (BoundSignature)boundSignature, 1));
        builder.add(Signature.builder((String)LAG_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E")}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (BoundSignature)boundSignature, -1));
        builder.add(Signature.builder((String)LAG_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E"), DataTypes.INTEGER.getTypeSignature()}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (BoundSignature)boundSignature, -1));
        builder.add(Signature.builder((String)LAG_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[]{TypeSignature.parse((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parse((String)"E")}).returnType(TypeSignature.parse((String)"E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}).build(), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (BoundSignature)boundSignature, -1));
    }
}

