/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.ConditionalBackReferenceGroup;
import com.oracle.truffle.regex.tregex.parser.ast.GlobalSubTreeIndex;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.GroupsWithGuardsIndex;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.ASTDebugDumpVisitor;
import com.oracle.truffle.regex.tregex.string.AbstractStringBuffer;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class RegexAST
implements StateIndex<RegexASTNode>,
JsonConvertible {
    private final RegexLanguage language;
    private final RegexSource source;
    private RegexFlags flags;
    private AbstractRegexObject flavorSpecificFlags;
    private final Counter.ThresholdCounter nodeCount = new Counter.ThresholdCounter(Integer.MAX_VALUE, "parse tree explosion");
    private final Counter.ThresholdCounter groupCount = new Counter.ThresholdCounter(Short.MAX_VALUE, "too many capture groups");
    private final RegexProperties properties = new RegexProperties();
    private final TBitSet referencedGroups = new TBitSet(64);
    private final TBitSet recursivelyReferencedGroups = new TBitSet(64);
    private final TBitSet conditionGroups = new TBitSet(64);
    private RegexASTNode[] nodes;
    private Group root;
    private Group wrappedRoot;
    private final List<Group> captureGroups = new ArrayList<Group>();
    private final List<Token.Quantifier> quantifiers = new ArrayList<Token.Quantifier>();
    private final List<QuantifiableTerm> zeroWidthQuantifiables = new ArrayList<QuantifiableTerm>();
    private final GlobalSubTreeIndex subtrees = new GlobalSubTreeIndex();
    private final GroupsWithGuardsIndex groupsWithGuards = new GroupsWithGuardsIndex();
    private final List<PositionAssertion> reachableCarets = new ArrayList<PositionAssertion>();
    private final List<PositionAssertion> reachableDollars = new ArrayList<PositionAssertion>();
    private StateSet<RegexAST, PositionAssertion> nfaAnchoredInitialStates;
    private StateSet<RegexAST, RegexASTNode> hardPrefixNodes;
    private final EconomicMap<GroupBoundaries, GroupBoundaries> groupBoundariesDeduplicationMap = EconomicMap.create();
    private final EconomicMap<RegexASTNode, List<SourceSection>> sourceSections;

    public RegexAST(RegexLanguage language, RegexSource source, RegexFlags flags) {
        this.language = language;
        this.source = source;
        this.flags = flags;
        this.sourceSections = source.getOptions().isDumpAutomataWithSourceSections() ? EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE) : null;
    }

    public RegexLanguage getLanguage() {
        return this.language;
    }

    public RegexSource getSource() {
        return this.source;
    }

    public RegexFlags getFlags() {
        return this.flags;
    }

    public void setFlags(RegexFlags flags) {
        this.flags = flags;
    }

    public AbstractRegexObject getFlavorSpecificFlags() {
        return this.flavorSpecificFlags;
    }

    public void setFlavorSpecificFlags(AbstractRegexObject flavorSpecificFlags) {
        this.flavorSpecificFlags = flavorSpecificFlags;
    }

    public RegexOptions getOptions() {
        return this.source.getOptions();
    }

    public Encodings.Encoding getEncoding() {
        return this.source.getEncoding();
    }

    public Group getRoot() {
        return this.root;
    }

    public void setRoot(Group root) {
        this.root = root;
    }

    public Group getWrappedRoot() {
        return this.wrappedRoot;
    }

    public boolean rootIsWrapped() {
        return this.wrappedRoot != null && this.root != this.wrappedRoot;
    }

    public Counter.ThresholdCounter getNodeCount() {
        return this.nodeCount;
    }

    public int getNumberOfNodes() {
        return this.nodeCount.getCount();
    }

    public Counter.ThresholdCounter getGroupCount() {
        return this.groupCount;
    }

    public int getNumberOfCaptureGroups() {
        return this.groupCount.getCount();
    }

    public int getQuantifierCount() {
        return this.quantifiers.size();
    }

    public void registerQuantifier(QuantifiableTerm quantifiable) {
        quantifiable.getQuantifier().setIndex(this.quantifiers.size());
        this.quantifiers.add(quantifiable.getQuantifier());
    }

    public Token.Quantifier[] getQuantifierArray() {
        return (Token.Quantifier[])this.quantifiers.toArray(Token.Quantifier[]::new);
    }

    public void registerZeroWidthQuantifiable(QuantifiableTerm zeroWidthQuantifiable) {
        zeroWidthQuantifiable.getQuantifier().setZeroWidthIndex(this.zeroWidthQuantifiables.size());
        this.zeroWidthQuantifiables.add(zeroWidthQuantifiable);
    }

    public List<QuantifiableTerm> getZeroWidthQuantifiables() {
        return this.zeroWidthQuantifiables;
    }

    public Group getGroup(int index) {
        return this.captureGroups.get(index);
    }

    public Group getGroupByBoundaryIndex(int index) {
        return this.captureGroups.get(index / 2);
    }

    public RegexProperties getProperties() {
        return this.properties;
    }

    public boolean isLiteralString() {
        Group r = this.getRoot();
        RegexProperties p = this.getProperties();
        return !p.hasBackReferences() && !p.hasAlternations() && !p.hasLookAroundAssertions() && !r.hasLoops() && (!r.startsWithCaret() && !r.endsWithDollar() || !this.getFlags().isMultiline()) && (!p.hasCharClasses() || p.charClassesCanBeMatchedWithMask());
    }

    @Override
    public int getNumberOfStates() {
        return this.nodes.length;
    }

    @Override
    public int getId(RegexASTNode state) {
        return state.getId();
    }

    @Override
    public RegexASTNode getState(int id) {
        return this.nodes[id];
    }

    public void setIndex(RegexASTNode[] index) {
        this.nodes = index;
    }

    public int getWrappedPrefixLength() {
        if (this.rootIsWrapped()) {
            return this.wrappedRoot.getFirstAlternative().size() - (this.flags.isSticky() ? 1 : 2);
        }
        return 0;
    }

    public RegexASTNode getEntryAfterPrefix() {
        if (this.rootIsWrapped()) {
            return this.wrappedRoot.getFirstAlternative().getTerms().get(this.getWrappedPrefixLength());
        }
        return this.wrappedRoot;
    }

    public GlobalSubTreeIndex getSubtrees() {
        return this.subtrees;
    }

    public void registerGroupWithGuards(Group group) {
        if (group.getGroupsWithGuardsIndex() < 0) {
            this.groupsWithGuards.add(group);
        }
    }

    public GroupsWithGuardsIndex getGroupsWithGuards() {
        return this.groupsWithGuards;
    }

    public List<PositionAssertion> getReachableCarets() {
        return this.reachableCarets;
    }

    public List<PositionAssertion> getReachableDollars() {
        return this.reachableDollars;
    }

    public StateSet<RegexAST, PositionAssertion> getNfaAnchoredInitialStates() {
        return this.nfaAnchoredInitialStates;
    }

    public StateSet<RegexAST, RegexASTNode> getHardPrefixNodes() {
        return this.hardPrefixNodes;
    }

    public RegexASTRootNode createRootNode() {
        RegexASTRootNode node = new RegexASTRootNode();
        this.createNFAHelperNodes(node);
        return node;
    }

    public BackReference createBackReference(int[] groupNumbers) {
        for (int groupNumber : groupNumbers) {
            this.referencedGroups.set(groupNumber);
        }
        return this.register(new BackReference(groupNumbers));
    }

    public TBitSet getReferencedGroups() {
        return this.referencedGroups;
    }

    public boolean isGroupReferenced(int groupNumber) {
        return this.referencedGroups.get(groupNumber);
    }

    public void setGroupRecursivelyReferenced(int groupNumber) {
        this.recursivelyReferencedGroups.set(groupNumber);
    }

    public boolean isGroupRecursivelyReferenced(int groupNumber) {
        return this.recursivelyReferencedGroups.get(groupNumber);
    }

    public CharacterClass createCharacterClass(CodePointSet matcherBuilder) {
        assert (this.getEncoding().getFullSet().contains(matcherBuilder));
        return this.register(new CharacterClass(matcherBuilder));
    }

    public Group createGroup() {
        return this.register(new Group());
    }

    public Group createCaptureGroup(int groupNumber) {
        Group group = this.register(new Group(groupNumber));
        assert (this.captureGroups.size() == groupNumber);
        this.captureGroups.add(group);
        return group;
    }

    public Group createConditionalBackReferenceGroup(int referencedGroupNumber) {
        this.referencedGroups.set(referencedGroupNumber);
        this.conditionGroups.set(referencedGroupNumber);
        return this.register(new ConditionalBackReferenceGroup(referencedGroupNumber));
    }

    public TBitSet getConditionGroups() {
        return this.conditionGroups;
    }

    public LookAheadAssertion createLookAheadAssertion(boolean negated) {
        LookAheadAssertion assertion = new LookAheadAssertion(negated);
        this.createNFAHelperNodes(assertion);
        return this.register(assertion);
    }

    public LookBehindAssertion createLookBehindAssertion(boolean negated) {
        LookBehindAssertion assertion = new LookBehindAssertion(negated);
        this.createNFAHelperNodes(assertion);
        return this.register(assertion);
    }

    public AtomicGroup createAtomicGroup() {
        AtomicGroup atomicGroup = new AtomicGroup();
        this.createNFAHelperNodes(atomicGroup);
        return this.register(atomicGroup);
    }

    public void createNFAHelperNodes(RegexASTSubtreeRootNode rootNode) {
        this.nodeCount.inc(4);
        PositionAssertion anchored = new PositionAssertion(PositionAssertion.Type.CARET);
        rootNode.setAnchoredInitialState(anchored);
        MatchFound unAnchored = new MatchFound();
        rootNode.setUnAnchoredInitialState(unAnchored);
        MatchFound end = new MatchFound();
        rootNode.setMatchFound(end);
        PositionAssertion anchoredEnd = new PositionAssertion(PositionAssertion.Type.DOLLAR);
        rootNode.setAnchoredFinalState(anchoredEnd);
    }

    public PositionAssertion createPositionAssertion(PositionAssertion.Type type) {
        return this.register(new PositionAssertion(type));
    }

    public Sequence createSequence() {
        return this.register(new Sequence());
    }

    public SubexpressionCall createSubexpressionCall(int groupNumber) {
        return this.register(new SubexpressionCall(groupNumber));
    }

    public BackReference register(BackReference backReference) {
        this.nodeCount.inc();
        return backReference;
    }

    public CharacterClass register(CharacterClass characterClass) {
        this.nodeCount.inc();
        return characterClass;
    }

    public Group register(Group group) {
        this.nodeCount.inc();
        return group;
    }

    public ConditionalBackReferenceGroup register(ConditionalBackReferenceGroup group) {
        this.nodeCount.inc();
        return group;
    }

    public LookAheadAssertion register(LookAheadAssertion lookAheadAssertion) {
        this.nodeCount.inc();
        return lookAheadAssertion;
    }

    public LookBehindAssertion register(LookBehindAssertion lookBehindAssertion) {
        this.nodeCount.inc();
        return lookBehindAssertion;
    }

    public AtomicGroup register(AtomicGroup atomicGroup) {
        this.nodeCount.inc();
        return atomicGroup;
    }

    public PositionAssertion register(PositionAssertion positionAssertion) {
        this.nodeCount.inc();
        return positionAssertion;
    }

    public Sequence register(Sequence sequence) {
        this.nodeCount.inc();
        return sequence;
    }

    public SubexpressionCall register(SubexpressionCall subexpressionCall) {
        this.nodeCount.inc();
        return subexpressionCall;
    }

    public boolean isNFAInitialState(RegexASTNode node) {
        return node.getId() >= 1 && node.getId() <= this.getWrappedPrefixLength() * 2 + 2;
    }

    private void createNFAInitialStates() {
        if (this.nfaAnchoredInitialStates != null) {
            return;
        }
        this.hardPrefixNodes = StateSet.create(this);
        this.nfaAnchoredInitialStates = StateSet.create(this);
        int nextID = 1;
        MatchFound mf = new MatchFound();
        this.initNodeId(mf, nextID++);
        mf.setNext(this.getEntryAfterPrefix());
        PositionAssertion pos = new PositionAssertion(PositionAssertion.Type.CARET);
        this.initNodeId(pos, nextID++);
        this.nfaAnchoredInitialStates.add(pos);
        pos.setNext(this.getEntryAfterPrefix());
        for (int i = this.getWrappedPrefixLength() - 1; i >= 0; --i) {
            RegexASTNode prefixNode = this.getWrappedRoot().getFirstAlternative().getTerms().get(i);
            this.hardPrefixNodes.add(prefixNode);
            mf = new MatchFound();
            this.initNodeId(mf, nextID++);
            mf.setNext(prefixNode);
            pos = new PositionAssertion(PositionAssertion.Type.CARET);
            this.initNodeId(pos, nextID++);
            this.nfaAnchoredInitialStates.add(pos);
            pos.setNext(prefixNode);
        }
    }

    public MatchFound getNFAUnAnchoredInitialState(int prefixOffset) {
        this.createNFAInitialStates();
        assert (this.nodes[prefixOffset * 2 + 1] != null);
        return (MatchFound)this.nodes[prefixOffset * 2 + 1];
    }

    public PositionAssertion getNFAAnchoredInitialState(int prefixOffset) {
        this.createNFAInitialStates();
        assert (this.nodes[prefixOffset * 2 + 2] != null);
        return (PositionAssertion)this.nodes[prefixOffset * 2 + 2];
    }

    public void createPrefix() {
        if (this.root.startsWithCaret() || this.properties.hasNonLiteralLookBehindAssertions()) {
            this.wrappedRoot = this.root;
            return;
        }
        if (this.properties.hasNestedLookBehindAssertions()) {
            throw new UnsupportedRegexException("nested look-behind assertions");
        }
        int prefixLength = this.root.getPrefixLengthMax();
        if (prefixLength == 0) {
            this.wrappedRoot = this.root;
            return;
        }
        Group wrapRoot = this.createGroup();
        wrapRoot.setPrefix();
        Sequence wrapRootSeq = this.createSequence();
        wrapRoot.add(wrapRootSeq);
        wrapRootSeq.setPrefix();
        for (int i = 0; i < prefixLength; ++i) {
            wrapRootSeq.add(this.createPrefixAnyMatcher());
        }
        if (!this.flags.isSticky()) {
            Group prevOpt = null;
            for (int i = 0; i < prefixLength; ++i) {
                Group opt = this.createGroup();
                opt.setPrefix();
                opt.add(this.createSequence());
                opt.add(this.createSequence());
                opt.getFirstAlternative().setPrefix();
                opt.getAlternatives().get(1).setPrefix();
                opt.getAlternatives().get(1).add(this.createPrefixAnyMatcher());
                if (prevOpt != null) {
                    opt.getAlternatives().get(1).add(prevOpt);
                }
                prevOpt = opt;
            }
            wrapRootSeq.add(prevOpt);
        }
        this.root.getSubTreeParent().setGroup(wrapRoot);
        wrapRootSeq.add(this.root);
        this.wrappedRoot = wrapRoot;
    }

    public void hidePrefix() {
        if (this.wrappedRoot != this.root) {
            this.root.getSubTreeParent().setGroup(this.root);
        }
    }

    public void unhidePrefix() {
        if (this.wrappedRoot != this.root) {
            this.root.getSubTreeParent().setGroup(this.wrappedRoot);
        }
    }

    public GroupBoundaries createGroupBoundaries(TBitSet updateIndices, TBitSet clearIndices, int lastGroup) {
        GroupBoundaries staticInstance;
        if (!this.getOptions().getFlavor().usesLastGroupResultField() && (staticInstance = GroupBoundaries.getStaticInstance(this.language, updateIndices, clearIndices)) != null) {
            return staticInstance;
        }
        GroupBoundaries lookup = new GroupBoundaries(updateIndices, clearIndices, lastGroup);
        if (this.groupBoundariesDeduplicationMap.containsKey((Object)lookup)) {
            return (GroupBoundaries)this.groupBoundariesDeduplicationMap.get((Object)lookup);
        }
        GroupBoundaries gb = new GroupBoundaries(updateIndices.copy(), clearIndices.copy(), lastGroup);
        this.groupBoundariesDeduplicationMap.put((Object)gb, (Object)gb);
        return gb;
    }

    private CharacterClass createPrefixAnyMatcher() {
        CharacterClass anyMatcher = this.createCharacterClass(this.getEncoding().getFullSet());
        anyMatcher.setPrefix();
        return anyMatcher;
    }

    private void addToIndex(RegexASTNode node) {
        assert (node.getId() >= 0);
        assert (node.getId() < this.nodes.length);
        assert (this.nodes[node.getId()] == null);
        this.nodes[node.getId()] = node;
    }

    private void initNodeId(RegexASTNode node, int id) {
        node.setId(id);
        this.addToIndex(node);
    }

    public List<SourceSection> getSourceSections(RegexASTNode node) {
        return this.getOptions().isDumpAutomataWithSourceSections() ? (List)this.sourceSections.get((Object)node) : null;
    }

    public void addSourceSection(RegexASTNode node, SourceSection sourceSection) {
        if (this.getOptions().isDumpAutomataWithSourceSections() && sourceSection != null) {
            this.getOrCreateSourceSections(node).add(sourceSection);
        }
    }

    public void addSourceSections(RegexASTNode node, Collection<SourceSection> src) {
        if (this.getOptions().isDumpAutomataWithSourceSections() && src != null) {
            this.getOrCreateSourceSections(node).addAll(src);
        }
    }

    private List<SourceSection> getOrCreateSourceSections(RegexASTNode node) {
        ArrayList sections = (ArrayList)this.sourceSections.get((Object)node);
        if (sections == null) {
            sections = new ArrayList();
            this.sourceSections.put((Object)node, sections);
        }
        return sections;
    }

    public InnerLiteral extractInnerLiteral() {
        assert (this.properties.hasInnerLiteral());
        int literalEnd = this.properties.getInnerLiteralEnd();
        int literalStart = this.properties.getInnerLiteralStart();
        AbstractStringBuffer literal = this.getEncoding().createStringBuffer(literalEnd - literalStart);
        AbstractStringBuffer mask = this.getEncoding().createStringBuffer(literalEnd - literalStart);
        boolean hasMask = false;
        for (int i = literalStart; i < literalEnd; ++i) {
            CharacterClass cc = this.root.getFirstAlternative().getTerms().get(i).asCharacterClass();
            assert (cc.getCharSet().matchesSingleChar() || cc.getCharSet().matches2CharsWith1BitDifference());
            assert (this.getEncoding().isFixedCodePointWidth(cc.getCharSet()));
            cc.extractSingleChar(literal, mask);
            hasMask |= cc.getCharSet().matches2CharsWith1BitDifference();
        }
        int maxPrefixSize = this.root.getFirstAlternative().get(literalStart).getMaxPath() - 1;
        for (int i = 0; i < literalStart; ++i) {
            if (!this.root.getFirstAlternative().getTerms().get(i).hasLoops()) continue;
            maxPrefixSize = -1;
        }
        return new InnerLiteral(literal.materialize(), hasMask ? mask.materialize() : null, maxPrefixSize);
    }

    public boolean canTransformToDFA() {
        boolean couldCalculateLastGroup = !this.getOptions().getFlavor().usesLastGroupResultField() || !this.getProperties().hasCaptureGroupsInLookAroundAssertions();
        return this.getNumberOfNodes() <= 4000 && this.getNumberOfCaptureGroups() <= 127 && !this.getProperties().hasBackReferences() && !this.getProperties().hasLargeCountedRepetitions() && !this.getProperties().hasNegativeLookAheadAssertions() && !this.getProperties().hasNonLiteralLookBehindAssertions() && !this.getProperties().hasNegativeLookBehindAssertions() && !this.getRoot().hasQuantifiers() && !this.getProperties().hasAtomicGroups() && !this.getProperties().hasConditionalReferencesIntoLookAheads() && couldCalculateLastGroup;
    }

    @CompilerDirectives.TruffleBoundary
    public String canTransformToDFAFailureReason() {
        StringJoiner sb = new StringJoiner(", ");
        if (this.getOptions().getFlavor().usesLastGroupResultField() && this.getProperties().hasCaptureGroupsInLookAroundAssertions()) {
            sb.add("regex has capture groups in look-around assertions while needing to calculate last group matched");
        }
        if (this.getNumberOfNodes() > 4000) {
            sb.add(String.format("Parser tree has too many nodes: %d (threshold: %d)", this.getNumberOfNodes(), 4000));
        }
        if (this.getNumberOfCaptureGroups() > 127) {
            sb.add(String.format("regex has too many capture groups: %d (threshold: %d)", this.getNumberOfCaptureGroups(), 127));
        }
        if (this.getProperties().hasBackReferences()) {
            sb.add("regex has back-references");
        }
        if (this.getProperties().hasLargeCountedRepetitions()) {
            sb.add(String.format("regex has large counted repetitions (threshold: %d for single CC, %d for groups)", 20, 6));
        }
        if (this.getProperties().hasNegativeLookAheadAssertions()) {
            sb.add("regex has negative look-ahead assertions");
        }
        if (this.getProperties().hasNegativeLookBehindAssertions()) {
            sb.add("regex has negative look-behind assertions");
        }
        if (this.getProperties().hasNonLiteralLookBehindAssertions()) {
            sb.add("regex has non-literal look-behind assertions");
        }
        if (this.getRoot().hasQuantifiers()) {
            sb.add("could not unroll all quantifiers");
        }
        if (this.getProperties().hasAtomicGroups()) {
            sb.add("regex has atomic groups");
        }
        if (this.getProperties().hasConditionalReferencesIntoLookAheads()) {
            sb.add("regex has conditional back-references into look-ahead assertions");
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("source", this.source), Json.prop("root", this.root), Json.prop("debugAST", ASTDebugDumpVisitor.getDump(this.wrappedRoot)), Json.prop("wrappedRoot", this.wrappedRoot), Json.prop("reachableCarets", this.reachableCarets), Json.prop("startsWithCaret", this.root.startsWithCaret()), Json.prop("endsWithDollar", this.root.endsWithDollar()), Json.prop("reachableDollars", this.reachableDollars), Json.prop("properties", this.properties));
    }

    @CompilerDirectives.TruffleBoundary
    public static JsonArray sourceSectionsToJson(List<SourceSection> sourceSections) {
        if (sourceSections == null) {
            return Json.array(new JsonConvertible[0]);
        }
        return RegexAST.sourceSectionsToJson(sourceSections.stream());
    }

    @CompilerDirectives.TruffleBoundary
    public static JsonArray sourceSectionsToJson(Stream<SourceSection> sourceSections) {
        if (sourceSections == null) {
            return Json.array(new JsonConvertible[0]);
        }
        return Json.array(sourceSections.map(x -> Json.obj(Json.prop("start", x.getCharIndex()), Json.prop("end", x.getCharEndIndex()))));
    }
}

