/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.language;

import io.crate.expression.udf.UDFLanguage;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.operation.language.PolyglotScalar;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.Nullable;

public final class PolyglotLanguage
implements UDFLanguage {
    private static final Engine ENGINE = Engine.newBuilder().option("js.foreign-object-prototype", "true").option("engine.WarnInterpreterOnly", "false").build();
    private static final HostAccess HOST_ACCESS = HostAccess.newBuilder().allowListAccess(true).allowArrayAccess(true).allowMapAccess(true).build();
    private final String verboseLanguage;
    private final String graalLanguageId;

    public PolyglotLanguage(String verboseLanguage, String graalLanguageId) {
        this.verboseLanguage = verboseLanguage;
        this.graalLanguageId = graalLanguageId;
    }

    public Scalar<?, ?> createFunctionImplementation(UserDefinedFunctionMetadata metadata, Signature signature, BoundSignature boundSignature) throws ScriptException {
        return new PolyglotScalar(signature, boundSignature, this.graalLanguageId, metadata.definition());
    }

    @Nullable
    public String validate(UserDefinedFunctionMetadata meta) {
        try {
            PolyglotLanguage.getFunctionValue(this.graalLanguageId, meta.name(), meta.definition());
            return null;
        }
        catch (IOException | IllegalArgumentException | PolyglotException t) {
            return String.format(Locale.ENGLISH, "Invalid %s in function '%s.%s(%s)' AS '%s': %s", this.verboseLanguage, meta.schema(), meta.name(), meta.argumentTypes().stream().map(DataType::getName).collect(Collectors.joining(", ")), meta.definition(), t.getMessage());
        }
    }

    public String name() {
        return this.verboseLanguage;
    }

    static Value getFunctionValue(String graalLanguageId, String functionName, String script) throws IOException {
        Context context = Context.newBuilder((String[])new String[]{graalLanguageId}).engine(ENGINE).allowHostAccess(HOST_ACCESS).build();
        Source source = Source.newBuilder((String)graalLanguageId, (CharSequence)script, (String)functionName).build();
        context.eval(source);
        Value polyglotFunctionValue = context.getBindings(graalLanguageId).getMember(functionName);
        if (polyglotFunctionValue == null) {
            throw new IllegalArgumentException("The name of the function signature '" + functionName + "' doesn't match the function name in the function definition.");
        }
        return polyglotFunctionValue;
    }
}

