/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class TopNDistinctBatchIterator<T>
implements BatchIterator<T> {
    private final BatchIterator<T> source;
    private final Set<T> items;
    private final int limit;
    private final Function<? super T, ? extends T> memoizeItem;

    public TopNDistinctBatchIterator(BatchIterator<T> source, int limit, Function<? super T, ? extends T> memoizeItem) {
        this.source = source;
        this.items = new HashSet<T>();
        this.limit = limit;
        this.memoizeItem = memoizeItem;
    }

    public void kill(@NotNull Throwable throwable) {
        this.source.kill(throwable);
    }

    @Override
    public T currentElement() {
        return this.source.currentElement();
    }

    @Override
    public void moveToStart() {
        this.items.clear();
        this.source.moveToStart();
    }

    @Override
    public boolean moveNext() {
        if (this.items.size() == this.limit) {
            return false;
        }
        while (this.source.moveNext()) {
            if (this.items.contains(this.source.currentElement())) continue;
            T materializedItem = this.memoizeItem.apply(this.source.currentElement());
            boolean added = this.items.add(materializedItem);
            assert (added) : ".add must return true if .contains was false. source.currentElement() (" + String.valueOf(this.source.currentElement()) + " has a different hashCode/equals implementation than " + String.valueOf(materializedItem);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        return this.source.loadNextBatch();
    }

    @Override
    public boolean allLoaded() {
        return this.items.size() == this.limit || this.source.allLoaded();
    }

    @Override
    public boolean hasLazyResultSet() {
        return this.source.hasLazyResultSet();
    }
}

