/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCheck;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.BoundCreateTable;
import io.crate.analyze.DDLStatement;
import io.crate.analyze.NumberOfShards;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.analyze.TableParameters;
import io.crate.analyze.TableProperties;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.IndexReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.settings.NumberOfReplicas;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.PartitionedBy;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.settings.Settings;

public record AnalyzedCreateTable(RelationName relationName, boolean ifNotExists, Map<ColumnIdent, TableElementsAnalyzer.RefBuilder> columns, Map<String, AnalyzedCheck> checks, GenericProperties<Symbol> properties, Optional<PartitionedBy<Reference>> partitionedBy, Optional<ClusteredBy<Symbol>> clusteredBy) implements DDLStatement
{
    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (TableElementsAnalyzer.RefBuilder refBuilder : this.columns.values()) {
            refBuilder.visitSymbols(consumer);
        }
        for (AnalyzedCheck check : this.checks.values()) {
            consumer.accept(check.check());
        }
        this.properties.forValues(consumer);
        this.partitionedBy.ifPresent(x -> x.columns().forEach(consumer));
        this.clusteredBy.ifPresent(x -> {
            x.column().ifPresent(consumer);
            x.numberOfShards().ifPresent(consumer);
        });
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    public BoundCreateTable bind(NumberOfShards numberOfShards, FulltextAnalyzerResolver fulltextAnalyzerResolver, NodeContext nodeCtx, TransactionContext txnCtx, Row params, SubQueryResults subQueryResults) {
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        SymbolEvaluator evaluator = new SymbolEvaluator(txnCtx, nodeCtx, subQueryResults);
        Function<Symbol, Object> toValue = evaluator.bind(params);
        Integer numShards = this.clusteredBy.flatMap(ClusteredBy::numberOfShards).map(toValue).map(numberOfShards::fromNumberOfShards).orElseGet(numberOfShards::defaultNumberOfShards);
        Settings.Builder builder = Settings.builder().put("index.number_of_shards", numShards).put(NumberOfReplicas.SETTING.getDefault(Settings.EMPTY));
        LinkedHashMap<ColumnIdent, Reference> references = new LinkedHashMap<ColumnIdent, Reference>();
        LinkedHashSet<Reference> primaryKeys = new LinkedHashSet<Reference>();
        HashSet<String> pkConstraintNames = new HashSet<String>();
        for (Map.Entry<ColumnIdent, TableElementsAnalyzer.RefBuilder> entry : this.columns.entrySet()) {
            IndexReference indexRef;
            String analyzer;
            ColumnIdent columnIdent = entry.getKey();
            TableElementsAnalyzer.RefBuilder column = entry.getValue();
            Reference reference = column.build(this.columns, this.relationName, paramBinder, toValue);
            references.put(columnIdent, reference);
            if (column.isPrimaryKey()) {
                primaryKeys.add(reference);
                pkConstraintNames.add(column.pkConstraintName());
            }
            if (!(reference instanceof IndexReference) || !fulltextAnalyzerResolver.hasCustomAnalyzer(analyzer = (indexRef = (IndexReference)reference).analyzer())) continue;
            Settings settings = fulltextAnalyzerResolver.resolveFullCustomAnalyzerSettings(analyzer);
            builder.put(settings);
        }
        String pkConstraintName = null;
        if (!pkConstraintNames.isEmpty()) {
            if (pkConstraintNames.size() > 1) {
                throw new IllegalArgumentException("More than one name for PRIMARY KEY constraint provided: " + String.join((CharSequence)",", pkConstraintNames));
            }
            pkConstraintName = (String)pkConstraintNames.iterator().next();
            if ("".equals(pkConstraintName)) {
                throw new IllegalArgumentException("The name of primary key constraint must not be empty, please either use a name or remove the CONSTRAINT keyword");
            }
        }
        TableProperties.analyze(builder, TableParameters.TABLE_CREATE_PARAMETER_INFO, (GenericProperties<Object>)this.properties.map(toValue));
        Optional<ColumnIdent> optClusteredBy = this.clusteredBy.flatMap(ClusteredBy::column).map(Symbol::toColumn);
        optClusteredBy.ifPresent(c -> {
            if (!primaryKeys.isEmpty() && Reference.indexOf(primaryKeys, c) < 0) {
                throw new IllegalArgumentException("Clustered by column `" + String.valueOf(c) + "` must be part of primary keys: " + String.valueOf(Lists.map((Collection)primaryKeys, Reference::column)));
            }
        });
        ColumnIdent routingColumn = optClusteredBy.orElse(null);
        List<Reference> partitionedByColumns = this.partitionedBy.map(PartitionedBy::columns).orElse(List.of());
        return new BoundCreateTable(this.relationName, pkConstraintName, this.ifNotExists, references, builder.build(), List.copyOf(primaryKeys), this.checks, routingColumn, partitionedByColumns);
    }
}

