/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.Map;
import java.util.function.Consumer;

public class AnalyzedOptimizeTable
implements DDLStatement {
    private final Map<Table<Symbol>, TableInfo> tables;
    private final GenericProperties<Symbol> properties;

    AnalyzedOptimizeTable(Map<Table<Symbol>, TableInfo> tables, GenericProperties<Symbol> properties) {
        this.tables = tables;
        this.properties = properties;
    }

    public GenericProperties<Symbol> properties() {
        return this.properties;
    }

    public Map<Table<Symbol>, TableInfo> tables() {
        return this.tables;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Table<Symbol> table : this.tables.keySet()) {
            for (Assignment partitionProperty : table.partitionProperties()) {
                consumer.accept((Symbol)partitionProperty.expression());
                partitionProperty.expressions().forEach(consumer);
            }
        }
        this.properties.forValues(consumer);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitOptimizeTableStatement(this, context);
    }
}

