/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateSnapshot;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Lists;
import io.crate.execution.ddl.RepositoryService;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

class CreateSnapshotAnalyzer {
    private final RepositoryService repositoryService;
    private final NodeContext nodeCtx;

    CreateSnapshotAnalyzer(RepositoryService repositoryService, NodeContext nodeCtx) {
        this.repositoryService = repositoryService;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateSnapshot analyze(CreateSnapshot<Expression> createSnapshot, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        String repositoryName = createSnapshot.name().getPrefix().map(name -> {
            this.validateRepository((QualifiedName)name);
            return name.toString();
        }).orElseThrow(() -> new IllegalArgumentException("Snapshot must be specified by \"<repository_name>\".\"<snapshot_name>\""));
        String snapshotName = createSnapshot.name().getSuffix();
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        List tables = Lists.map((Collection)createSnapshot.tables(), table -> table.map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx)));
        GenericProperties properties = createSnapshot.properties().map(x -> exprAnalyzerWithoutFields.convert((Expression)x, exprCtx));
        return new AnalyzedCreateSnapshot(repositoryName, snapshotName, tables, (GenericProperties<Symbol>)properties);
    }

    private void validateRepository(QualifiedName name) {
        if (name.getParts().size() != 1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid repository name '%s'", name));
        }
        this.repositoryService.failIfRepositoryDoesNotExist(name.toString());
    }
}

