/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.exceptions.ConversionException;
import io.crate.expression.BaseImplementationSymbolVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.OuterColumn;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataType;
import java.util.function.Function;

public final class SymbolEvaluator
extends BaseImplementationSymbolVisitor<Row> {
    private final SubQueryResults subQueryResults;

    public SymbolEvaluator(TransactionContext txnCtx, NodeContext nodeCtx, SubQueryResults subQueryResults) {
        super(txnCtx, nodeCtx);
        this.subQueryResults = subQueryResults;
    }

    public static Object evaluateWithoutParams(TransactionContext txn, NodeContext nodeCtx, Symbol symbol) {
        return SymbolEvaluator.evaluate(txn, nodeCtx, symbol, Row.EMPTY, SubQueryResults.EMPTY);
    }

    public static Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Symbol symbol, Row params, SubQueryResults subQueryValues) {
        SymbolEvaluator symbolEval = new SymbolEvaluator(txnCtx, nodeCtx, subQueryValues);
        return ((Input)symbol.accept(symbolEval, params)).value();
    }

    @Override
    public Input<?> visitParameterSymbol(ParameterSymbol parameterSymbol, Row params) {
        return () -> {
            Object value = parameterSymbol.bind(params);
            try {
                return parameterSymbol.valueType().implicitCast(value);
            }
            catch (ConversionException e) {
                throw e;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(value, parameterSymbol.valueType());
            }
        };
    }

    @Override
    public Input<?> visitSelectSymbol(SelectSymbol selectSymbol, Row context) {
        DataType<?> type = selectSymbol.valueType();
        return Literal.of(type, type.sanitizeValue(this.subQueryResults.getSafe(selectSymbol)));
    }

    @Override
    public Input<?> visitOuterColumn(OuterColumn outerColumn, Row context) {
        DataType<?> valueType = outerColumn.valueType();
        return Literal.ofUnchecked(valueType, valueType.sanitizeValue(this.subQueryResults.get(outerColumn)));
    }

    public Function<Symbol, Object> bind(Row params) {
        return x -> ((Input)x.accept(this, params)).value();
    }
}

