/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.TableParameters;
import io.crate.common.unit.TimeValue;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.format.Style;
import io.crate.fdw.ForeignTable;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.NumberOfReplicas;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CreateForeignTable;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.DefaultConstraint;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GeneratedExpressionConstraint;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.Literal;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableElement;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import io.crate.types.StorageSupport;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.jetbrains.annotations.Nullable;

public class TableInfoToAST {
    private final TableInfo tableInfo;

    public TableInfoToAST(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public Statement toStatement() {
        TableInfo table;
        QualifiedName name = QualifiedName.of((String)this.tableInfo.ident().fqn(), (String[])new String[0]);
        List<TableElement<Expression>> tableElements = this.extractTableElements();
        TableInfo tableInfo = this.tableInfo;
        if (tableInfo instanceof DocTableInfo) {
            DocTableInfo docTable = (DocTableInfo)tableInfo;
            table = new Table(name, false);
            Optional<PartitionedBy<Expression>> partitionedBy = this.createPartitionedBy(docTable);
            Optional<ClusteredBy<Expression>> clusteredBy = this.createClusteredBy(docTable);
            return new CreateTable((Table)table, tableElements, partitionedBy, clusteredBy, this.extractTableProperties(), true);
        }
        table = this.tableInfo;
        if (table instanceof ForeignTable) {
            ForeignTable foreignTable = (ForeignTable)table;
            HashMap<String, Literal> options = new HashMap<String, Literal>();
            for (Map.Entry<String, Object> entry : foreignTable.options().getAsStructuredMap().entrySet()) {
                String optionName = entry.getKey();
                Object optionValue = entry.getValue();
                options.put(optionName, Literal.fromObject((Object)optionValue));
            }
            return new CreateForeignTable(name, true, tableElements, foreignTable.server(), options);
        }
        throw new UnsupportedOperationException("Cannot convert " + this.tableInfo.getClass().getSimpleName() + " to AST");
    }

    private List<TableElement<Expression>> extractTableElements() {
        ArrayList<TableElement<Expression>> elements = new ArrayList<TableElement<Expression>>();
        elements.addAll(this.extractColumnDefinitions(null));
        PrimaryKeyConstraint<Expression> pk = this.extractPrimaryKeyConstraint();
        if (pk != null) {
            elements.add((TableElement<Expression>)pk);
        }
        elements.addAll(this.extractIndexDefinitions());
        this.tableInfo.checkConstraints().stream().map(chk -> new CheckConstraint(chk.name(), (Object)SqlParser.createExpression((String)chk.expressionStr()), chk.expressionStr())).forEach(elements::add);
        return elements;
    }

    private List<ColumnDefinition<Expression>> extractColumnDefinitions(@Nullable ColumnIdent parent) {
        Iterator referenceIterator = this.tableInfo.iterator();
        ArrayList<ColumnDefinition<Expression>> elements = new ArrayList<ColumnDefinition<Expression>>();
        while (referenceIterator.hasNext()) {
            Symbol defaultExpr;
            Reference ref = (Reference)referenceIterator.next();
            ColumnIdent ident = ref.column();
            if (ident.isSystemColumn() || parent != null && !ident.isChildOf(parent) || parent == null && !ident.path().isEmpty() || parent != null && ident.getParent().compareTo(parent) > 0) continue;
            ColumnType<Expression> columnType = ref.valueType().toColumnType(() -> this.extractColumnDefinitions(ident));
            ArrayList<Object> constraints = new ArrayList<Object>();
            if (ref instanceof GeneratedReference) {
                GeneratedReference generatedRef = (GeneratedReference)ref;
                String formattedExpression = generatedRef.formattedGeneratedExpression();
                Expression generatedExpression = SqlParser.createExpression((String)formattedExpression);
                constraints.add(new GeneratedExpressionConstraint(null, (Object)generatedExpression, formattedExpression));
            }
            if ((defaultExpr = ref.defaultExpression()) != null) {
                String symbol = defaultExpr.toString(Style.UNQUALIFIED);
                Expression defaultExpression = SqlParser.createExpression((String)symbol);
                constraints.add(new DefaultConstraint(null, (Object)defaultExpression, symbol));
            }
            if (!ref.isNullable()) {
                constraints.add(new NotNullColumnConstraint());
            }
            if (ref.indexType().equals((Object)IndexType.NONE) && ref.valueType().id() != 12 && (ref.valueType().id() != 100 || ((ArrayType)ref.valueType()).innerType().id() != 12)) {
                constraints.add(IndexColumnConstraint.off());
            } else if (ref.indexType().equals((Object)IndexType.FULLTEXT)) {
                String analyzer = ((DocTableInfo)this.tableInfo).getAnalyzerForColumnIdent(ident);
                properties = analyzer == null ? GenericProperties.empty() : new GenericProperties(Map.of(FulltextAnalyzerResolver.CustomType.ANALYZER.getName(), new StringLiteral(analyzer)));
                constraints.add(new IndexColumnConstraint("fulltext", (GenericProperties)properties));
            } else if (ArrayType.unnest(ref.valueType()).equals(DataTypes.GEO_SHAPE)) {
                GeoReference geoReference;
                if (ref instanceof GeneratedReference) {
                    GeneratedReference genRef = (GeneratedReference)ref;
                    geoReference = (GeoReference)genRef.reference();
                } else {
                    geoReference = (GeoReference)ref;
                }
                properties = new HashMap();
                if (geoReference.distanceErrorPct() != null) {
                    properties.put("distance_error_pct", Literal.fromObject((Object)geoReference.distanceErrorPct()));
                }
                if (geoReference.precision() != null) {
                    properties.put("precision", Literal.fromObject((Object)geoReference.precision()));
                }
                if (geoReference.treeLevels() != null) {
                    properties.put("tree_levels", Literal.fromObject((Object)geoReference.treeLevels()));
                }
                constraints.add(new IndexColumnConstraint(geoReference.geoTree(), new GenericProperties((Map)properties)));
            }
            StorageSupport<?> storageSupport = ref.valueType().storageSupportSafe();
            boolean hasDocValuesPerDefault = storageSupport.getComputedDocValuesDefault(ref.indexType());
            if (hasDocValuesPerDefault != ref.hasDocValues()) {
                GenericProperties properties = new GenericProperties(Map.of("columnstore", Literal.fromObject((Object)ref.hasDocValues())));
                constraints.add(new ColumnStorageDefinition(properties));
            }
            String columnName = ident.leafName();
            elements.add((ColumnDefinition<Expression>)new ColumnDefinition(columnName, columnType, constraints));
        }
        return elements;
    }

    private PrimaryKeyConstraint<Expression> extractPrimaryKeyConstraint() {
        if (!this.tableInfo.primaryKey().isEmpty()) {
            if (this.tableInfo.primaryKey().size() == 1 && this.tableInfo.primaryKey().get(0).isSystemColumn()) {
                return null;
            }
            return new PrimaryKeyConstraint(this.tableInfo.pkConstraintName(), TableInfoToAST.expressionsFromColumns(this.tableInfo.primaryKey()));
        }
        return null;
    }

    private List<IndexDefinition<Expression>> extractIndexDefinitions() {
        TableInfo tableInfo = this.tableInfo;
        if (!(tableInfo instanceof DocTableInfo)) {
            return List.of();
        }
        DocTableInfo docTable = (DocTableInfo)tableInfo;
        Collection<IndexReference> indexColumns = docTable.indexColumns();
        ArrayList<IndexDefinition<Expression>> elements = new ArrayList<IndexDefinition<Expression>>(indexColumns.size());
        for (IndexReference indexRef : indexColumns) {
            String name = indexRef.column().name();
            List<Expression> columns = TableInfoToAST.expressionsFromReferences(indexRef.columns());
            if (indexRef.indexType().equals((Object)IndexType.FULLTEXT)) {
                String analyzer = indexRef.analyzer();
                GenericProperties properties = analyzer == null ? GenericProperties.empty() : new GenericProperties(Map.of(FulltextAnalyzerResolver.CustomType.ANALYZER.getName(), new StringLiteral(analyzer)));
                elements.add((IndexDefinition<Expression>)new IndexDefinition(name, "fulltext", columns, properties));
                continue;
            }
            if (!indexRef.indexType().equals((Object)IndexType.PLAIN)) continue;
            elements.add((IndexDefinition<Expression>)new IndexDefinition(name, "plain", columns, GenericProperties.empty()));
        }
        return elements;
    }

    private Optional<PartitionedBy<Expression>> createPartitionedBy(DocTableInfo docTable) {
        if (docTable.partitionedBy().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PartitionedBy(TableInfoToAST.expressionsFromColumns(docTable.partitionedBy())));
    }

    private Optional<ClusteredBy<Expression>> createClusteredBy(DocTableInfo docTable) {
        ColumnIdent clusteredByColumn = docTable.clusteredBy();
        Expression clusteredBy = clusteredByColumn == null || clusteredByColumn.isSystemColumn() ? null : clusteredByColumn.toExpression();
        LongLiteral numShards = new LongLiteral((long)docTable.numberOfShards());
        return Optional.of(new ClusteredBy(Optional.ofNullable(clusteredBy), Optional.of(numShards)));
    }

    private GenericProperties<Expression> extractTableProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String numberOfReplicasKey = TableParameters.stripIndexPrefix(NumberOfReplicas.SETTING.getKey());
        TableInfo tableInfo = this.tableInfo;
        if (tableInfo instanceof DocTableInfo) {
            DocTableInfo docTable = (DocTableInfo)tableInfo;
            StringLiteral numReplicas = new StringLiteral(docTable.numberOfReplicas());
            properties.put(numberOfReplicasKey, numReplicas);
            properties.put("column_policy", new StringLiteral(docTable.columnPolicy().lowerCaseName()));
        }
        Settings parameters = this.tableInfo.parameters();
        Map<String, Setting<?>> supportedSettings = TableParameters.TABLE_CREATE_PARAMETER_INFO.supportedSettings();
        for (Map.Entry<String, Setting<?>> entry : supportedSettings.entrySet()) {
            String settingName = entry.getKey();
            if (settingName.equals(numberOfReplicasKey)) continue;
            Setting<?> setting = entry.getValue();
            if (setting instanceof Setting.AffixSetting) {
                Setting.AffixSetting affixSetting = (Setting.AffixSetting)setting;
                String prefix = affixSetting.getKey();
                Set<String> namespaces = affixSetting.getNamespaces(parameters);
                for (String namespace : namespaces) {
                    String key = prefix + namespace;
                    Object value = affixSetting.getConcreteSetting(key).get(parameters);
                    properties.put(TableParameters.stripIndexPrefix(key), TableInfoToAST.literalOfSettingValue(value));
                }
                continue;
            }
            if (!parameters.hasValue(setting.getKey())) continue;
            Object value = setting.get(parameters);
            properties.put(settingName, TableInfoToAST.literalOfSettingValue(value));
        }
        return new GenericProperties(properties);
    }

    private static Literal literalOfSettingValue(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        String result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteSizeValue.class, TimeValue.class, Number.class, Boolean.class}, (Object)object2, n)) {
            case 0 -> {
                ByteSizeValue byteSizeValue = (ByteSizeValue)object2;
                yield byteSizeValue.getBytes();
            }
            case 1 -> {
                TimeValue timeValue = (TimeValue)object2;
                yield timeValue.millis();
            }
            case 2 -> {
                Number x = (Number)object2;
                yield x;
            }
            case 3 -> {
                Boolean x = (Boolean)object2;
                yield x;
            }
            default -> value.toString();
        };
        return Literal.fromObject((Object)result);
    }

    private static List<Expression> expressionsFromReferences(List<Reference> columns) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(columns.size());
        for (Reference ident : columns) {
            expressions.add(ident.column().toExpression());
        }
        return expressions;
    }

    private static List<Expression> expressionsFromColumns(List<ColumnIdent> columns) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(columns.size());
        for (ColumnIdent ident : columns) {
            expressions.add(ident.toExpression());
        }
        return expressions;
    }
}

