/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedDropView;
import io.crate.analyze.CreateViewStmt;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.RelationsUnknown;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.sql.SqlFormatter;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.CreateView;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Query;
import java.util.ArrayList;

public final class ViewAnalyzer {
    private final RelationAnalyzer relationAnalyzer;
    private final Schemas schemas;

    ViewAnalyzer(RelationAnalyzer relationAnalyzer, Schemas schemas) {
        this.relationAnalyzer = relationAnalyzer;
        this.schemas = schemas;
    }

    public CreateViewStmt analyze(CreateView createView, CoordinatorTxnCtx txnCtx) {
        AnalyzedRelation query;
        String formattedQuery;
        RelationName name = RelationName.of(createView.name(), txnCtx.sessionSettings().searchPath().currentSchema());
        name.ensureValidForRelationCreation();
        if ("blob".equals(name.schema())) {
            throw new UnsupportedOperationException("Creating a view in the \"blob\" schema is not supported");
        }
        try {
            formattedQuery = SqlFormatter.formatSql((Node)createView.query());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Invalid query used in CREATE VIEW. Query: " + String.valueOf(createView.query()));
        }
        try {
            query = this.relationAnalyzer.analyze((Query)SqlParser.createStatement((String)formattedQuery), txnCtx, ParamTypeHints.EMPTY);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Invalid query used in CREATE VIEW. " + e.getMessage() + ". Query: " + formattedQuery);
        }
        if (query.outputs().stream().map(f -> f.toColumn().sqlFqn()).distinct().count() != (long)query.outputs().size()) {
            throw new IllegalArgumentException("Query in CREATE VIEW must not have duplicate column names");
        }
        return new CreateViewStmt(name, query, createView.query(), createView.replaceExisting(), txnCtx.sessionSettings().sessionUser());
    }

    public AnalyzedDropView analyze(DropView dropView, CoordinatorTxnCtx txnCtx) {
        ArrayList<RelationName> views = new ArrayList<RelationName>(dropView.names().size());
        ArrayList<RelationName> missing = new ArrayList<RelationName>();
        for (QualifiedName qualifiedName : dropView.names()) {
            try {
                views.add(this.schemas.findView(qualifiedName, txnCtx.sessionSettings().searchPath()).name());
            }
            catch (RelationUnknown e) {
                if (dropView.ifExists()) continue;
                missing.add(RelationName.of(qualifiedName, txnCtx.sessionSettings().searchPath().currentSchema()));
            }
        }
        if (!missing.isEmpty()) {
            throw new RelationsUnknown(missing);
        }
        return new AnalyzedDropView(views, dropView.ifExists());
    }
}

