/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.FieldResolver;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.VoidReference;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AliasedAnalyzedRelation
implements AnalyzedRelation,
FieldResolver {
    private final AnalyzedRelation relation;
    private final RelationName alias;
    private final Map<ColumnIdent, ColumnIdent> aliasToColumnMapping;
    private final ArrayList<Symbol> outputs;
    private final ArrayList<ScopedSymbol> scopedSymbols;

    public AliasedAnalyzedRelation(AnalyzedRelation relation, RelationName alias) {
        this(relation, alias, List.of());
    }

    AliasedAnalyzedRelation(AnalyzedRelation relation, RelationName alias, List<String> columnAliases) {
        ColumnIdent columnAlias;
        ColumnIdent childColumn;
        Symbol childOutput;
        int i;
        this.relation = relation;
        this.alias = alias;
        this.aliasToColumnMapping = HashMap.newHashMap(columnAliases.size());
        this.outputs = new ArrayList(relation.outputs().size());
        this.scopedSymbols = new ArrayList(relation.outputs().size());
        for (i = 0; i < relation.outputs().size(); ++i) {
            childOutput = relation.outputs().get(i);
            columnAlias = childColumn = childOutput.toColumn();
            if (i < columnAliases.size()) {
                columnAlias = ColumnIdent.of(columnAliases.get(i));
            }
            this.aliasToColumnMapping.put(columnAlias, childColumn);
            ScopedSymbol scopedSymbol = new ScopedSymbol(alias, columnAlias, childOutput);
            this.outputs.add(scopedSymbol);
            this.scopedSymbols.add(scopedSymbol);
        }
        for (i = 0; i < relation.hiddenOutputs().size(); ++i) {
            childOutput = relation.hiddenOutputs().get(i);
            columnAlias = childColumn = childOutput.toColumn();
            if (i + relation.outputs().size() < columnAliases.size()) {
                columnAlias = ColumnIdent.of(columnAliases.get(i));
            }
            this.aliasToColumnMapping.putIfAbsent(columnAlias, childColumn);
        }
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        Symbol field;
        if (operation != Operation.READ) {
            throw new UnsupportedOperationException(String.valueOf((Object)operation) + " is not supported on " + String.valueOf(this.alias));
        }
        ColumnIdent childColumnName = this.aliasToColumnMapping.get(column);
        if (childColumnName == null) {
            if (column.isRoot()) {
                return null;
            }
            childColumnName = this.aliasToColumnMapping.get(column.getRoot());
            if (childColumnName == null) {
                ColumnIdent maybeQuotedSubscriptColumnAlias = ColumnIdent.of(column.sqlFqn());
                childColumnName = this.aliasToColumnMapping.get(maybeQuotedSubscriptColumnAlias);
                if (childColumnName == null) {
                    return null;
                }
                column = maybeQuotedSubscriptColumnAlias;
            } else {
                childColumnName = ColumnIdent.of(childColumnName.name(), column.path());
            }
        }
        if ((field = this.relation.getField(childColumnName, operation, errorOnUnknownObjectKey)) == null) {
            return null;
        }
        if (field instanceof VoidReference) {
            VoidReference voidReference = (VoidReference)field;
            return new VoidReference(new ReferenceIdent(this.alias, voidReference.column()), voidReference.position());
        }
        ScopedSymbol scopedSymbol = new ScopedSymbol(this.alias, column, field);
        int i = this.scopedSymbols.indexOf(scopedSymbol);
        if (i >= 0) {
            return this.scopedSymbols.get(i);
        }
        this.scopedSymbols.add(scopedSymbol);
        return scopedSymbol;
    }

    public AnalyzedRelation relation() {
        return this.relation;
    }

    @Override
    public RelationName relationName() {
        return this.alias;
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public String toString() {
        return String.valueOf(this.relation) + " AS " + String.valueOf(this.alias);
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitAliasedAnalyzedRelation(this, context);
    }

    @Override
    @Nullable
    public Symbol resolveField(ScopedSymbol field) {
        if (!field.relation().equals(this.alias)) {
            throw new IllegalArgumentException(String.valueOf(field) + " does not belong to " + String.valueOf(this.relationName()));
        }
        ColumnIdent column = field.column();
        ColumnIdent childColumnName = this.aliasToColumnMapping.get(column);
        if (childColumnName == null && !column.isRoot()) {
            ColumnIdent childCol = this.aliasToColumnMapping.get(column.getRoot());
            childColumnName = ColumnIdent.of(childCol.name(), column.path());
        }
        assert (childColumnName != null) : "If a ScopedSymbol has been retrieved via `getField`, it must be possible to get the columnIdent";
        Symbol result = this.relation.getField(childColumnName, Operation.READ);
        if (result == null) {
            throw new IllegalArgumentException(String.valueOf(field) + " does not belong to " + String.valueOf(this.relationName()));
        }
        return result;
    }
}

