/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.validator;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.types.BitStringType;
import io.crate.types.DataTypes;
import io.crate.types.FloatVectorType;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SemanticSortValidator {
    private static final InnerValidator INNER_VALIDATOR = new InnerValidator();
    public static final Set<Integer> SUPPORTED_TYPES = Stream.concat(DataTypes.PRIMITIVE_TYPES.stream(), Stream.of(DataTypes.REGCLASS, DataTypes.REGPROC, DataTypes.NUMERIC, BitStringType.INSTANCE_ONE, FloatVectorType.INSTANCE_ONE)).map(x -> x.id()).collect(Collectors.toSet());

    public static void validate(Symbol symbol) throws UnsupportedOperationException {
        symbol.accept(INNER_VALIDATOR, new SortContext("ORDER BY"));
    }

    public static void validate(Symbol symbol, String operation) throws UnsupportedOperationException {
        symbol.accept(INNER_VALIDATOR, new SortContext(operation));
    }

    private static class InnerValidator
    extends SymbolVisitor<SortContext, Void> {
        private InnerValidator() {
        }

        @Override
        public Void visitFunction(Function symbol, SortContext context) {
            if (!context.inFunction && !SUPPORTED_TYPES.contains(symbol.valueType().id())) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot %s '%s': invalid return type '%s'.", context.operation, symbol, symbol.valueType()));
            }
            context.inFunction = true;
            for (Symbol arg : symbol.arguments()) {
                arg.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitMatchPredicate(MatchPredicate matchPredicate, SortContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "%s predicate cannot be used in an %s clause", "match", context.operation));
        }

        @Override
        public Void visitSymbol(Symbol symbol, SortContext context) {
            if (!context.inFunction && !SUPPORTED_TYPES.contains(symbol.valueType().id())) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot %s '%s': invalid data type '%s'.", context.operation, symbol, symbol.valueType()));
            }
            return null;
        }
    }

    static class SortContext {
        private final String operation;
        private boolean inFunction;

        SortContext(String operation) {
            this.operation = operation;
            this.inFunction = false;
        }
    }
}

