/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.action.ActionListeners;
import io.crate.execution.ddl.RelationNameSwap;
import io.crate.execution.ddl.SwapRelationsOperation;
import io.crate.execution.ddl.SwapRelationsRequest;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportSwapRelationsAction
extends TransportMasterNodeAction<SwapRelationsRequest, AcknowledgedResponse> {
    private final SwapRelationsOperation swapRelationsOperation;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public TransportSwapRelationsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, DDLClusterStateService ddlClusterStateService, AllocationService allocationService) {
        super("internal:crate:sql/alter/cluster/indices", transportService, clusterService, threadPool, SwapRelationsRequest::new);
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
        this.swapRelationsOperation = new SwapRelationsOperation(allocationService, ddlClusterStateService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(final SwapRelationsRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        final AtomicReference<Object> indexNamesAfterRelationSwap = new AtomicReference<Object>(null);
        ActionListener<AcknowledgedResponse> waitForShardsListener = ActionListeners.waitForShards(listener, this.activeShardsObserver, request.ackTimeout(), () -> this.logger.info("Switched name of relations, but the operation timed out waiting for enough shards to be started"), indexNamesAfterRelationSwap::get);
        AckedClusterStateUpdateTask<AcknowledgedResponse> updateTask = new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, Priority.HIGH, (AckedRequest)request, waitForShardsListener){
            final /* synthetic */ TransportSwapRelationsAction this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                if (this.this$0.logger.isInfoEnabled()) {
                    Iterable swapActions = request.swapActions().stream().map(x -> x.source().fqn() + " <-> " + x.target().fqn())::iterator;
                    this.this$0.logger.info("Swapping tables [{}]", (Object)String.join((CharSequence)", ", swapActions));
                }
                SwapRelationsOperation.UpdatedState newState = this.this$0.swapRelationsOperation.execute(currentState, request);
                indexNamesAfterRelationSwap.set(newState.newIndices.toArray(new String[0]));
                return newState.newState;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        };
        this.clusterService.submitStateUpdateTask("swap-relations", updateTask);
    }

    @Override
    protected ClusterBlockException checkBlock(SwapRelationsRequest request, ClusterState state) {
        HashSet<String> affectedIndices = new HashSet<String>();
        Metadata metadata = state.metadata();
        for (RelationNameSwap swapAction : request.swapActions()) {
            affectedIndices.addAll(Arrays.asList(IndexNameExpressionResolver.concreteIndexNames(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, swapAction.source().indexNameOrAlias())));
            affectedIndices.addAll(Arrays.asList(IndexNameExpressionResolver.concreteIndexNames(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, swapAction.target().indexNameOrAlias())));
        }
        for (RelationName dropRelation : request.dropRelations()) {
            affectedIndices.addAll(Arrays.asList(IndexNameExpressionResolver.concreteIndexNames(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, dropRelation.indexNameOrAlias())));
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, affectedIndices.toArray(new String[0]));
    }
}

