/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import java.io.IOException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.jetbrains.annotations.Nullable;

public class AlterTableTask<T>
extends DDLClusterStateTaskExecutor<T> {
    private final NodeContext nodeContext;
    private final RelationName relationName;
    private final AlterTableOperator<T> alterTableOperator;
    @Nullable
    private final FulltextAnalyzerResolver fulltextAnalyzerResolver;

    public AlterTableTask(NodeContext nodeContext, RelationName relationName, @Nullable FulltextAnalyzerResolver fulltextAnalyzerResolver, AlterTableOperator<T> alterTableOperator) {
        this.nodeContext = nodeContext;
        this.relationName = relationName;
        this.alterTableOperator = alterTableOperator;
        this.fulltextAnalyzerResolver = fulltextAnalyzerResolver;
    }

    @Override
    public ClusterState execute(ClusterState currentState, T t) throws Exception {
        Metadata.Builder metadataBuilder;
        DocTableInfoFactory docTableInfoFactory = new DocTableInfoFactory(this.nodeContext);
        Metadata metadata = currentState.metadata();
        DocTableInfo currentTable = docTableInfoFactory.create(this.relationName, metadata);
        DocTableInfo newTable = this.alterTableOperator.apply(t, currentTable, metadataBuilder = Metadata.builder(metadata), this.nodeContext, this.fulltextAnalyzerResolver);
        if (newTable == currentTable) {
            return currentState;
        }
        newTable.writeTo(metadata, metadataBuilder);
        Metadata newMetadata = metadataBuilder.build();
        docTableInfoFactory.create(this.relationName, newMetadata);
        return ClusterState.builder(currentState).metadata(newMetadata).build();
    }

    public static interface AlterTableOperator<T> {
        public DocTableInfo apply(T var1, DocTableInfo var2, Metadata.Builder var3, NodeContext var4, FulltextAnalyzerResolver var5) throws IOException;
    }
}

