/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.analyze.DropColumn;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;

public class DropColumnRequest
extends AcknowledgedRequest<DropColumnRequest> {
    private final RelationName relationName;
    private final List<DropColumn> colsToDrop;

    public DropColumnRequest(@NotNull RelationName relationName, @NotNull List<DropColumn> colsToDrop) {
        this.relationName = relationName;
        this.colsToDrop = colsToDrop;
    }

    public DropColumnRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        this.colsToDrop = in.readList(DropColumn::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        out.writeCollection(this.colsToDrop);
    }

    @NotNull
    public RelationName relationName() {
        return this.relationName;
    }

    @NotNull
    public List<DropColumn> colsToDrop() {
        return this.colsToDrop;
    }
}

