/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.exceptions.RelationAlreadyExists;
import io.crate.execution.ddl.Templates;
import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportCreateTableAction
extends TransportMasterNodeAction<CreateTableRequest, CreateTableResponse> {
    public static final Action ACTION = new Action();
    private final MetadataCreateIndexService createIndexService;
    private final IndicesService indicesService;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportCreateTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService, IndexScopedSettings indexScopedSettings, MetadataCreateIndexService createIndexService) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateTableRequest::new);
        this.createIndexService = createIndexService;
        this.indicesService = indicesService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected CreateTableResponse read(StreamInput in) throws IOException {
        return new CreateTableResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateTableRequest request, ClusterState state) {
        boolean isPartitioned;
        RelationName relationName = request.getTableName();
        assert (relationName != null) : "relationName must not be null";
        boolean bl = isPartitioned = !request.partitionedBy().isEmpty();
        if (isPartitioned) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, relationName.indexNameOrAlias());
    }

    @Override
    protected void masterOperation(final CreateTableRequest request, ClusterState state, ActionListener<CreateTableResponse> listener) {
        RelationName relationName = request.getTableName();
        if (state.metadata().contains(relationName)) {
            listener.onFailure(new RelationAlreadyExists(relationName));
            return;
        }
        Settings.Builder settingsBuilder = Settings.builder().put(request.settings()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), state.nodes().getSmallestNonClientNodeVersion()).normalizePrefix("index.");
        final Settings normalizedSettings = settingsBuilder.build();
        MetadataCreateIndexService.validateSoftDeletesSetting(normalizedSettings);
        this.indexScopedSettings.validate(normalizedSettings, true);
        final boolean isPartitioned = !request.partitionedBy().isEmpty();
        ActionListener<Object> stateUpdateListener = isPartitioned ? listener.map(resp -> new CreateTableResponse(resp.isAcknowledged())) : this.createIndexService.withWaitForShards(listener, relationName.indexNameOrAlias(), ActiveShardCount.DEFAULT, request.ackTimeout(), (stateAck, shardsAck) -> new CreateTableResponse(stateAck != false && shardsAck != false));
        AckedClusterStateUpdateTask<ClusterStateUpdateResponse> createTableTask = new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, stateUpdateListener){
            final /* synthetic */ TransportCreateTableAction this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                if (isPartitioned) {
                    return Templates.add(this.this$0.indicesService, this.this$0.createIndexService, currentState, request, normalizedSettings);
                }
                return this.this$0.createIndexService.add(currentState, request, normalizedSettings);
            }
        };
        this.clusterService.submitStateUpdateTask("create-table", createTableTask);
    }

    public static class Action
    extends ActionType<CreateTableResponse> {
        public static final String NAME = "internal:crate:sql/tables/admin/create";

        public Action() {
            super(NAME);
        }
    }
}

