/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import com.carrotsearch.hppc.IntCollection;
import io.crate.action.FutureActionListener;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dml.BulkResponse;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.support.MultiActionListener;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;

final class BulkShardResponseListener
implements ActionListener<ShardResponse> {
    private final ShardResponse.CompressedResult compressedResult;
    private final FutureActionListener<BulkResponse> results;
    private final MultiActionListener<ShardResponse, ShardResponse.CompressedResult, BulkResponse> listener;

    BulkShardResponseListener(int numCallbacks, int numBulkParams, IntCollection resultIndices) {
        BulkResponse bulkResponse = new BulkResponse(numBulkParams);
        this.results = new FutureActionListener();
        this.compressedResult = new ShardResponse.CompressedResult();
        this.listener = new MultiActionListener<ShardResponse, ShardResponse.CompressedResult, BulkResponse>(numCallbacks, () -> this.compressedResult, BulkShardResponseListener::onResponse, responses -> bulkResponse.update((ShardResponse.CompressedResult)responses, resultIndices), this.results);
    }

    private static void onResponse(ShardResponse.CompressedResult result, ShardResponse response) {
        Exception failure = response.failure();
        if (failure == null) {
            result.update(response);
        } else {
            Throwable t = SQLExceptions.unwrap(failure);
            if (!(t instanceof DocumentMissingException) && !(t instanceof VersionConflictEngineException)) {
                throw new RuntimeException(t);
            }
        }
    }

    public CompletableFuture<BulkResponse> bulkResponseFuture() {
        return this.results;
    }

    @Override
    public void onResponse(ShardResponse shardResponse) {
        this.listener.onResponse(shardResponse);
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }
}

