/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.data.Input;
import io.crate.execution.dml.ArrayIndexer;
import io.crate.execution.dml.Indexer;
import io.crate.execution.dml.TranslogWriter;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.doc.SysColumns;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SequenceIDFields;
import org.elasticsearch.index.mapper.Uid;

public class IndexDocumentBuilder {
    private final Document doc;
    private final TranslogWriter translogWriter;
    private final ValueIndexer.Synthetics synthetics;
    private final Map<ColumnIdent, Indexer.ColumnConstraint> constraints;
    private final Version tableVersionCreated;
    private final boolean addStoredField;
    private final boolean addArrayLengthField;

    public IndexDocumentBuilder(TranslogWriter translogWriter, ValueIndexer.Synthetics synthetics, Map<ColumnIdent, Indexer.ColumnConstraint> constraints, Version tableVersionCreated) {
        this(new Document(), translogWriter, synthetics, constraints, tableVersionCreated, tableVersionCreated.onOrAfter(StoredRowLookup.PARTIAL_STORED_SOURCE_VERSION), tableVersionCreated.onOrAfter(ArrayIndexer.ARRAY_LENGTH_FIELD_SUPPORTED_VERSION));
    }

    private IndexDocumentBuilder(Document doc, TranslogWriter translogWriter, ValueIndexer.Synthetics synthetics, Map<ColumnIdent, Indexer.ColumnConstraint> constraints, Version tableVersionCreated, boolean addStoredField, boolean addArrayLengthField) {
        this.doc = doc;
        this.translogWriter = translogWriter;
        this.synthetics = synthetics;
        this.constraints = constraints;
        this.tableVersionCreated = tableVersionCreated;
        this.addStoredField = addStoredField;
        this.addArrayLengthField = addArrayLengthField;
    }

    public void addField(IndexableField field) {
        this.doc.add(field);
    }

    public TranslogWriter translogWriter() {
        return this.translogWriter;
    }

    public Object getSyntheticValue(ColumnIdent columnIdent) {
        Input<Object> input = this.synthetics.get(columnIdent);
        return input == null ? null : input.value();
    }

    public void checkColumnConstraint(ColumnIdent columnIdent, Object value) {
        Indexer.ColumnConstraint constraint = this.constraints.get(columnIdent);
        if (constraint != null) {
            constraint.verify(value);
        }
    }

    public boolean maybeAddStoredField() {
        return this.addStoredField;
    }

    public boolean maybeAddArrayLengthField() {
        return this.addArrayLengthField;
    }

    public IndexDocumentBuilder noStoredField() {
        return new IndexDocumentBuilder(this.doc, this.translogWriter, this.synthetics, this.constraints, this.tableVersionCreated, false, this.addArrayLengthField);
    }

    public IndexDocumentBuilder noArrayLengthField() {
        return new IndexDocumentBuilder(this.doc, this.translogWriter, this.synthetics, this.constraints, this.tableVersionCreated, this.addStoredField, false);
    }

    public IndexDocumentBuilder wrapTranslog(UnaryOperator<TranslogWriter> wrapFunction) {
        return new IndexDocumentBuilder(this.doc, (TranslogWriter)wrapFunction.apply(this.translogWriter), this.synthetics, this.constraints, this.tableVersionCreated, this.addStoredField, this.addArrayLengthField);
    }

    public ParsedDocument build(String id) {
        NumericDocValuesField version = new NumericDocValuesField("_version", -1L);
        this.addField((IndexableField)version);
        BytesReference translog = this.translogWriter.bytes();
        BytesRef translogRef = translog.toBytesRef();
        if (this.tableVersionCreated.onOrAfter(StoredRowLookup.PARTIAL_STORED_SOURCE_VERSION)) {
            this.addField((IndexableField)new StoredField("_recovery_source", translogRef.bytes, translogRef.offset, translogRef.length));
            this.addField((IndexableField)new NumericDocValuesField("_recovery_source", 1L));
        } else {
            this.addField((IndexableField)new StoredField("_source", translogRef.bytes, translogRef.offset, translogRef.length));
        }
        BytesRef idBytes = Uid.encodeId(id);
        this.addField((IndexableField)new Field("_id", idBytes, (IndexableFieldType)SysColumns.ID.FIELD_TYPE));
        SequenceIDFields seqID = SequenceIDFields.emptySeqID();
        this.addField((IndexableField)seqID.seqNo);
        this.addField((IndexableField)seqID.seqNoDocValue);
        this.addField((IndexableField)seqID.primaryTerm);
        return new ParsedDocument((Field)version, seqID, id, this.doc, translog);
    }

    public Version getTableVersionCreated() {
        return this.tableVersionCreated;
    }
}

