/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Maps;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.dml.DynamicIndexer;
import io.crate.execution.dml.FulltextIndexer;
import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.ValueIndexer;
import io.crate.execution.dml.XContentTranslogWriter;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.jetbrains.annotations.Nullable;

public class Indexer {
    private final List<ValueIndexer<?>> valueIndexers;
    private final List<Reference> columns;
    private final Map<ColumnIdent, Synthetic> synthetics;
    private final List<CollectExpression<IndexItem, Object>> expressions;
    private final Map<ColumnIdent, ColumnConstraint> columnConstraints = new HashMap<ColumnIdent, ColumnConstraint>();
    private final List<TableConstraint> tableConstraints;
    private final List<IndexColumn<Input<?>>> indexColumns;
    private final List<Input<?>> returnValueInputs;
    private final List<Synthetic> undeterministic = new ArrayList<Synthetic>();
    private final Function<ColumnIdent, Reference> getRef;
    private final boolean writeOids;
    private final Version tableVersionCreated;

    public Indexer(String indexName, DocTableInfo table, Version shardVersionCreated, TransactionContext txnCtx, NodeContext nodeCtx, List<Reference> targetColumns, Symbol[] returnValues) {
        Input<?> input;
        this.columns = targetColumns;
        this.synthetics = new HashMap<ColumnIdent, Synthetic>();
        this.writeOids = table.versionCreated().onOrAfter(DocTableInfo.COLUMN_OID_VERSION);
        this.getRef = table::getReference;
        PartitionName partitionName = table.isPartitioned() ? PartitionName.fromIndexOrTemplate(indexName) : null;
        InputFactory inputFactory = new InputFactory(nodeCtx);
        SymbolEvaluator symbolEval = new SymbolEvaluator(txnCtx, nodeCtx, SubQueryResults.EMPTY);
        RefResolver referenceResolver = new RefResolver(symbolEval, partitionName, targetColumns, table);
        InputFactory.Context<CollectExpression<IndexItem, Object>> ctxForRefs = inputFactory.ctxForRefs(txnCtx, referenceResolver);
        this.valueIndexers = new ArrayList(targetColumns.size());
        int position = -1;
        for (Reference reference : targetColumns) {
            DynamicIndexer valueIndexer;
            if (reference instanceof DynamicReference) {
                if (table.columnPolicy() == ColumnPolicy.STRICT) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot add column `%s` to table `%s` with column policy `strict`", reference.column(), table.ident()));
                }
                valueIndexer = new DynamicIndexer(reference.ident(), position, this.getRef, this.writeOids);
                --position;
            } else {
                valueIndexer = reference.valueType().valueIndexer(table.ident(), reference, this.getRef);
            }
            this.valueIndexers.add(valueIndexer);
            Indexer.addGeneratedToVerify(this.columnConstraints, table, ctxForRefs, reference);
        }
        this.tableConstraints = new ArrayList<TableConstraint>(table.checkConstraints().size());
        Indexer.addNotNullConstraints(this.tableConstraints, this.columnConstraints, table, targetColumns, ctxForRefs);
        for (CheckConstraint checkConstraint : table.checkConstraints()) {
            Symbol expression = (Symbol)checkConstraint.expression();
            input = ctxForRefs.add(expression);
            this.tableConstraints.add(new TableCheckConstraint(input, (CheckConstraint<Symbol>)checkConstraint));
        }
        for (Reference reference : table.defaultExpressionColumns()) {
            if (targetColumns.contains(reference) || reference.granularity() == RowGranularity.PARTITION) continue;
            ColumnIdent column = reference.column();
            this.createParentSynthetics(table, targetColumns, column, this.getRef);
            input = table.primaryKey().contains(column) ? ctxForRefs.add(reference) : ctxForRefs.add(reference.defaultExpression());
            ValueIndexer<Object> valueIndexer = reference.valueType().valueIndexer(table.ident(), reference, this.getRef);
            Synthetic synthetic = new Synthetic(reference, input, valueIndexer);
            this.synthetics.put(column, synthetic);
            if (reference.defaultExpression().isDeterministic()) continue;
            this.undeterministic.add(synthetic);
        }
        for (GeneratedReference generatedReference : table.generatedColumns()) {
            if (generatedReference.granularity() == RowGranularity.PARTITION || targetColumns.contains(generatedReference)) continue;
            this.createParentSynthetics(table, targetColumns, generatedReference.column(), this.getRef);
            Input<?> input2 = ctxForRefs.add(generatedReference.generatedExpression());
            ValueIndexer<Object> valueIndexer = generatedReference.valueType().valueIndexer(table.ident(), generatedReference, this.getRef);
            Synthetic synthetic = new Synthetic(generatedReference, input2, valueIndexer);
            this.synthetics.put(generatedReference.column(), synthetic);
            if (generatedReference.isDeterministic()) continue;
            this.undeterministic.add(synthetic);
        }
        this.indexColumns = Indexer.buildIndexColumns(table.indexColumns(), table::getReference, ctxForRefs::add);
        if (returnValues == null) {
            this.returnValueInputs = null;
        } else {
            InputFactory.Context<Input> ctxForReturnValues = inputFactory.ctxForRefs(txnCtx, ref -> {
                Synthetic synthetic = this.synthetics.get(ref.column());
                if (synthetic == null) {
                    return ctxForRefs.add(ref);
                }
                return synthetic;
            });
            this.returnValueInputs = new ArrayList(returnValues.length);
            for (Symbol returnValue : returnValues) {
                this.returnValueInputs.add(ctxForReturnValues.add(returnValue));
            }
        }
        this.expressions = ctxForRefs.expressions();
        this.tableVersionCreated = shardVersionCreated;
    }

    public static <I> List<IndexColumn<I>> buildIndexColumns(Collection<IndexReference> indexReferences, Function<ColumnIdent, Reference> getRef, Function<Reference, ? extends I> createInput) {
        ArrayList<IndexColumn<I>> indexColumns = new ArrayList<IndexColumn<I>>(indexReferences.size());
        for (IndexReference ref : indexReferences) {
            ArrayList<I> indexInputs = new ArrayList<I>(ref.columns().size());
            for (Reference sourceRef : ref.columns()) {
                Reference reference = getRef.apply(sourceRef.column());
                assert (reference.equals(sourceRef)) : "refs must match";
                I input = createInput.apply(sourceRef);
                indexInputs.add(input);
            }
            if (ref.indexType() == IndexType.NONE) continue;
            indexColumns.add(new IndexColumn(ref, indexInputs));
        }
        return indexColumns;
    }

    private void createParentSynthetics(DocTableInfo table, List<Reference> targetColumns, ColumnIdent column, Function<ColumnIdent, Reference> getRef) {
        for (ColumnIdent parent : column.parents()) {
            if (this.synthetics.containsKey(parent) || Symbols.hasColumn(targetColumns, parent)) continue;
            Reference parentRef = table.getReference(parent);
            assert (parentRef != null) : "Must be able to retrieve Reference for parent of a `defaultExpressionColumn`";
            int dimensions = ArrayType.dimensions(parentRef.valueType());
            if (dimensions > 0) break;
            Input input = HashMap::new;
            ValueIndexer<Object> valueIndexer = parentRef.valueType().valueIndexer(table.ident(), parentRef, getRef);
            Synthetic synthetic = new Synthetic(parentRef, input, valueIndexer);
            this.synthetics.put(parent, synthetic);
        }
    }

    public void updateTargets(Function<ColumnIdent, Reference> getRef) {
        Iterator<Reference> it = this.columns.iterator();
        int idx = 0;
        while (it.hasNext()) {
            Reference oldRef = it.next();
            if (oldRef.oid() == Metadata.COLUMN_OID_UNASSIGNED) {
                newRef = getRef.apply(oldRef.column());
                if (newRef == null) {
                    this.valueIndexers.get(idx).updateTargets(getRef);
                    ++idx;
                    continue;
                }
                if (!oldRef.equals(newRef)) {
                    this.columns.set(idx, newRef);
                    this.valueIndexers.set(idx, newRef.valueType().valueIndexer(newRef.ident().tableIdent(), newRef, getRef));
                }
            } else if (DataTypes.isArrayOfNulls(oldRef.valueType())) {
                newRef = getRef.apply(oldRef.column());
                if (newRef == null) continue;
                if (newRef.valueType().id() == 100) {
                    this.columns.set(idx, newRef);
                    this.valueIndexers.set(idx, newRef.valueType().valueIndexer(newRef.ident().tableIdent(), newRef, getRef));
                }
            } else {
                this.valueIndexers.get(idx).updateTargets(getRef);
            }
            ++idx;
        }
        for (Map.Entry<ColumnIdent, Synthetic> entry : this.synthetics.entrySet()) {
            ColumnIdent column = entry.getKey();
            if (!column.isRoot()) continue;
            Synthetic synthetic = entry.getValue();
            ValueIndexer<Object> indexer = synthetic.indexer();
            indexer.updateTargets(getRef);
        }
    }

    private static void addNotNullConstraints(List<TableConstraint> tableConstraints, Map<ColumnIdent, ColumnConstraint> columnConstraints, DocTableInfo table, List<Reference> targetColumns, InputFactory.Context<CollectExpression<IndexItem, Object>> ctxForRefs) {
        for (ColumnIdent column : table.notNullColumns()) {
            Input<?> input;
            Reference ref = table.getReference(column);
            assert (ref != null) : "Column in #notNullColumns must be available via table.getReference";
            if (targetColumns.contains(ref)) {
                columnConstraints.merge(ref.column(), new NotNull(column), MultiCheck::merge);
                continue;
            }
            if (ref instanceof GeneratedReference) {
                GeneratedReference generated = (GeneratedReference)ref;
                input = ctxForRefs.add(generated.generatedExpression());
                tableConstraints.add(new NotNullTableConstraint(column, input));
                continue;
            }
            input = ctxForRefs.add(ref);
            tableConstraints.add(new NotNullTableConstraint(column, input));
        }
    }

    private static void addGeneratedToVerify(Map<ColumnIdent, ColumnConstraint> columnConstraints, DocTableInfo table, InputFactory.Context<?> ctxForRefs, Reference ref) {
        Object object;
        GeneratedReference generated;
        if (ref instanceof GeneratedReference && (generated = (GeneratedReference)ref).isDeterministic()) {
            Input<?> input = ctxForRefs.add(generated.generatedExpression());
            columnConstraints.put(ref.column(), new CheckGeneratedValue(input, generated));
        }
        if ((object = ref.valueType()) instanceof ObjectType) {
            ObjectType objectType = (ObjectType)object;
            for (Map.Entry entry : objectType.innerTypes().entrySet()) {
                String innerName = (String)entry.getKey();
                ColumnIdent innerColumn = ref.column().getChild(innerName);
                Reference reference = table.getReference(innerColumn);
                if (reference == null) continue;
                Indexer.addGeneratedToVerify(columnConstraints, table, ctxForRefs, reference);
            }
        }
    }

    public List<Reference> collectSchemaUpdates(IndexItem item) throws IOException {
        LinkedHashSet newColumns = new LinkedHashSet();
        Consumer<Reference> onDynamicColumn = ref -> {
            ref.column().validForCreate();
            newColumns.add(ref);
        };
        for (CollectExpression<IndexItem, Object> expression : this.expressions) {
            expression.setNextRow(item);
        }
        Object[] values = item.insertValues();
        for (int i = 0; i < values.length; ++i) {
            Reference reference = this.columns.get(i);
            Object value = Indexer.valueForInsert(reference.valueType(), values[i]);
            if (value == null) continue;
            ValueIndexer<?> valueIndexer = this.valueIndexers.get(i);
            valueIndexer.collectSchemaUpdates(reference.valueType().sanitizeValue(value), onDynamicColumn, this.synthetics::get);
        }
        for (Map.Entry<ColumnIdent, Synthetic> entry : this.synthetics.entrySet()) {
            ColumnIdent column = entry.getKey();
            if (!column.isRoot()) continue;
            Synthetic synthetic = entry.getValue();
            ValueIndexer<Object> indexer = synthetic.indexer();
            Object value = synthetic.value();
            if (value == null) continue;
            indexer.collectSchemaUpdates(value, onDynamicColumn, this.synthetics::get);
        }
        return newColumns.stream().toList();
    }

    public ParsedDocument index(IndexItem item) throws IOException {
        assert (item.insertValues().length <= this.valueIndexers.size()) : "Number of values must be less than or equal the number of targetColumns/valueIndexers";
        for (CollectExpression<IndexItem, Object> expression : this.expressions) {
            expression.setNextRow(item);
        }
        for (Synthetic synthetic : this.synthetics.values()) {
            synthetic.reset();
        }
        XContentTranslogWriter translogWriter = new XContentTranslogWriter();
        IndexDocumentBuilder docBuilder = new IndexDocumentBuilder(translogWriter, this.synthetics::get, this.columnConstraints, this.tableVersionCreated);
        Object[] values = item.insertValues();
        for (int i = 0; i < values.length; ++i) {
            Reference reference = this.columns.get(i);
            Object value = Indexer.valueForInsert(reference.valueType(), values[i]);
            ColumnConstraint check = this.columnConstraints.get(reference.column());
            if (check != null) {
                check.verify(value);
            }
            if (reference.granularity() == RowGranularity.PARTITION) continue;
            ValueIndexer<?> valueIndexer = this.valueIndexers.get(i);
            if (value == null) continue;
            translogWriter.writeFieldName(valueIndexer.storageIdentLeafName());
            valueIndexer.indexValue(value, docBuilder);
        }
        for (Map.Entry<ColumnIdent, Synthetic> entry : this.synthetics.entrySet()) {
            Synthetic synthetic;
            Object value;
            ColumnIdent column = entry.getKey();
            if (!column.isRoot() || (value = (synthetic = entry.getValue()).value()) == null) continue;
            ValueIndexer<Object> indexer = synthetic.indexer();
            translogWriter.writeFieldName(indexer.storageIdentLeafName());
            indexer.indexValue(value, docBuilder);
        }
        Indexer.addIndexColumns(this.indexColumns, docBuilder);
        for (TableConstraint constraint : this.tableConstraints) {
            constraint.verify(item.insertValues());
        }
        return docBuilder.build(item.id());
    }

    private static void addIndexColumns(List<IndexColumn<Input<?>>> indexColumns, IndexDocumentBuilder docBuilder) {
        for (IndexColumn<Input<?>> indexColumn : indexColumns) {
            String fqn = indexColumn.reference.storageIdent();
            for (Input input : indexColumn.inputs) {
                Object value = input.value();
                if (value == null) continue;
                if (value instanceof Iterable) {
                    Iterable it = (Iterable)value;
                    for (Object val : it) {
                        if (val == null) continue;
                        Field field = new Field(fqn, (CharSequence)val.toString(), (IndexableFieldType)FulltextIndexer.FIELD_TYPE);
                        docBuilder.addField((IndexableField)field);
                    }
                    continue;
                }
                Field field = new Field(fqn, (CharSequence)value.toString(), (IndexableFieldType)FulltextIndexer.FIELD_TYPE);
                docBuilder.addField((IndexableField)field);
            }
        }
    }

    private static <T> T valueForInsert(DataType<T> valueType, Object value) {
        return valueType.valueForInsert(valueType.sanitizeValue(value));
    }

    @Nullable
    public Object[] returnValues(IndexItem item) {
        if (this.returnValueInputs == null) {
            return null;
        }
        this.expressions.forEach(x -> x.setNextRow(item));
        Object[] result = new Object[this.returnValueInputs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.returnValueInputs.get(i).value();
        }
        return result;
    }

    public static Consumer<IndexItem> createConstraintCheck(String indexName, DocTableInfo table, TransactionContext txnCtx, NodeContext nodeCtx, List<Reference> targetColumns) {
        SymbolEvaluator symbolEval = new SymbolEvaluator(txnCtx, nodeCtx, SubQueryResults.EMPTY);
        PartitionName partitionName = table.isPartitioned() ? PartitionName.fromIndexOrTemplate(indexName) : null;
        InputFactory inputFactory = new InputFactory(nodeCtx);
        RefResolver referenceResolver = new RefResolver(symbolEval, partitionName, targetColumns, table);
        InputFactory.Context<CollectExpression<IndexItem, Object>> ctxForRefs = inputFactory.ctxForRefs(txnCtx, referenceResolver);
        HashMap<ColumnIdent, ColumnConstraint> columnConstraints = new HashMap<ColumnIdent, ColumnConstraint>();
        for (Reference ref : targetColumns) {
            Indexer.addGeneratedToVerify(columnConstraints, table, ctxForRefs, ref);
        }
        ArrayList<TableConstraint> tableConstraints = new ArrayList<TableConstraint>(table.checkConstraints().size());
        Indexer.addNotNullConstraints(tableConstraints, columnConstraints, table, targetColumns, ctxForRefs);
        for (CheckConstraint<Symbol> constraint : table.checkConstraints()) {
            Symbol expression = (Symbol)constraint.expression();
            Input<?> input = ctxForRefs.add(expression);
            tableConstraints.add(new TableCheckConstraint(input, constraint));
        }
        return indexItem -> {
            for (CollectExpression expression : ctxForRefs.expressions()) {
                expression.setNextRow(indexItem);
            }
            Object[] values = indexItem.insertValues();
            for (int i = 0; i < values.length; ++i) {
                Reference reference = (Reference)targetColumns.get(i);
                Object value = Indexer.valueForInsert(reference.valueType(), values[i]);
                ColumnConstraint check = (ColumnConstraint)columnConstraints.get(reference.column());
                if (check != null) {
                    check.verify(value);
                }
                if (reference.granularity() != RowGranularity.PARTITION && value != null) continue;
            }
            for (TableConstraint constraint : tableConstraints) {
                constraint.verify(values);
            }
        };
    }

    public List<Reference> columns() {
        return this.columns;
    }

    public List<Reference> insertColumns() {
        if (this.undeterministic.isEmpty()) {
            return this.columns;
        }
        ArrayList<Reference> newColumns = new ArrayList<Reference>(this.columns);
        for (Synthetic synthetic : this.undeterministic) {
            if (synthetic.ref.column().isRoot()) {
                if (newColumns.contains(synthetic.ref)) continue;
                newColumns.add(synthetic.ref);
                continue;
            }
            ColumnIdent rootIdent = synthetic.ref.column().getRoot();
            int rootIndex = Reference.indexOf(newColumns, rootIdent);
            if (rootIndex != -1) continue;
            Reference rootRef = this.getRef.apply(rootIdent);
            assert (rootRef != null) : "Root must exist in the table";
            newColumns.add(rootRef);
        }
        return newColumns;
    }

    public Object[] addGeneratedValues(IndexItem item) {
        Object[] insertValues = item.insertValues();
        if (this.undeterministic.isEmpty()) {
            return insertValues;
        }
        ArrayList<Object> extendedValues = new ArrayList<Object>(insertValues.length);
        Collections.addAll(extendedValues, insertValues);
        for (Synthetic synthetic : this.undeterministic) {
            Map root;
            ColumnIdent column = synthetic.ref.column();
            if (column.isRoot()) {
                extendedValues.add(synthetic.value());
                continue;
            }
            int valueIdx = Reference.indexOf(this.columns, column.getRoot());
            if (valueIdx == -1) {
                root = new HashMap();
                extendedValues.add(root);
            } else {
                assert (valueIdx < insertValues.length) : "Target columns and values must have the same size";
                root = (Map)insertValues[valueIdx];
            }
            ColumnIdent child = column.shiftRight();
            Object value = synthetic.value();
            Maps.mergeInto(root, (String)child.name(), child.path(), (Object)value, Map::putIfAbsent);
        }
        return extendedValues.toArray();
    }

    public boolean hasReturnValues() {
        return this.returnValueInputs != null;
    }

    static class RefResolver
    implements ReferenceResolver<CollectExpression<IndexItem, Object>> {
        private final PartitionName partitionName;
        private final List<Reference> targetColumns;
        private final DocTableInfo table;
        private final SymbolEvaluator symbolEval;

        private RefResolver(SymbolEvaluator symbolEval, PartitionName partitionName, List<Reference> targetColumns, DocTableInfo table) {
            this.symbolEval = symbolEval;
            this.partitionName = partitionName;
            this.targetColumns = targetColumns;
            this.table = table;
        }

        @Override
        public CollectExpression<IndexItem, Object> getImplementation(Reference ref) {
            int rootIndex;
            ColumnIdent column = ref.column();
            if (column.equals(SysColumns.ID.COLUMN)) {
                return NestableCollectExpression.forFunction(IndexItem::id);
            }
            if (column.equals(SysColumns.SEQ_NO)) {
                return NestableCollectExpression.forFunction(IndexItem::seqNo);
            }
            if (column.equals(SysColumns.PRIMARY_TERM)) {
                return NestableCollectExpression.forFunction(IndexItem::primaryTerm);
            }
            int pkIndex = this.table.primaryKey().indexOf(column);
            if (pkIndex > -1) {
                return NestableCollectExpression.forFunction(item -> ref.valueType().implicitCast(item.pkValues().get(pkIndex)));
            }
            int index = this.targetColumns.indexOf(ref);
            if (index > -1) {
                return NestableCollectExpression.forFunction(item -> item.insertValues()[index]);
            }
            if (ref.granularity() == RowGranularity.PARTITION) {
                int pIndex = this.table.partitionedByColumns().indexOf(ref);
                if (pIndex > -1) {
                    String val = this.partitionName.values().get(pIndex);
                    return NestableCollectExpression.constant(ref.valueType().implicitCast(val));
                }
                return NestableCollectExpression.constant(null);
            }
            if (column.isRoot()) {
                Symbol defaultExpression = ref.defaultExpression();
                if (defaultExpression == null) {
                    if (ref instanceof GeneratedReference) {
                        GeneratedReference generated = (GeneratedReference)ref;
                        return NestableCollectExpression.forFunction(item -> this.fromGenerated(generated, (IndexItem)item));
                    }
                    return NestableCollectExpression.constant(null);
                }
                return NestableCollectExpression.constant(((Input)defaultExpression.accept(this.symbolEval, Row.EMPTY)).value());
            }
            ColumnIdent root = column.getRoot();
            int rootIdx = -1;
            for (int i = 0; i < this.targetColumns.size(); ++i) {
                if (!this.targetColumns.get(i).column().equals(root)) continue;
                rootIdx = i;
                break;
            }
            if ((rootIndex = rootIdx) == -1) {
                return NestableCollectExpression.constant(null);
            }
            Function<IndexItem, Object> getValue = item -> {
                Object val = item.insertValues()[rootIndex];
                if (val instanceof Map) {
                    Map m = (Map)val;
                    List<String> path = column.path();
                    val = Maps.getByPath((Map)m, path);
                }
                if (val == null) {
                    Symbol defaultExpression = ref.defaultExpression();
                    if (defaultExpression != null) {
                        val = ((Input)defaultExpression.accept(this.symbolEval, Row.EMPTY)).value();
                    } else if (ref instanceof GeneratedReference) {
                        GeneratedReference generated = (GeneratedReference)ref;
                        return this.fromGenerated(generated, (IndexItem)item);
                    }
                }
                return val;
            };
            return NestableCollectExpression.forFunction(getValue);
        }

        private Object fromGenerated(GeneratedReference generated, IndexItem item) {
            Symbol generatedExpression = RefReplacer.replaceRefs(generated.generatedExpression(), x -> {
                Input collectExpression = this.getImplementation((Reference)x);
                collectExpression.setNextRow(item);
                return Literal.ofUnchecked(x.valueType(), collectExpression.value());
            });
            Input accept = (Input)generatedExpression.accept(this.symbolEval, Row.EMPTY);
            return accept.value();
        }
    }

    record TableCheckConstraint(Input<?> input, CheckConstraint<Symbol> checkConstraint) implements TableConstraint
    {
        @Override
        public void verify(Object[] values) {
            Boolean bool;
            Object value = this.input.value();
            if (value instanceof Boolean && !(bool = (Boolean)value).booleanValue()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Failed CONSTRAINT %s CHECK (%s) for values: %s", this.checkConstraint.name(), this.checkConstraint.expressionStr(), Arrays.toString(values)));
            }
        }
    }

    private static class Synthetic
    implements Input<Object> {
        private final Reference ref;
        private final Input<?> input;
        private final ValueIndexer<Object> indexer;
        private boolean computed;
        private Object computedValue;

        public Synthetic(Reference ref, Input<?> input, ValueIndexer<Object> indexer) {
            this.ref = ref;
            this.input = input;
            this.indexer = indexer;
        }

        public ValueIndexer<Object> indexer() {
            return this.indexer;
        }

        public Object value() {
            if (!this.computed) {
                this.computedValue = this.input.value();
                this.computed = true;
            }
            return this.computedValue;
        }

        public void reset() {
            this.computed = false;
            this.computedValue = null;
        }
    }

    public record IndexColumn<I>(Reference reference, List<? extends I> inputs) {
    }

    record NotNull(ColumnIdent column) implements ColumnConstraint
    {
        @Override
        public void verify(Object providedValue) {
            if (providedValue == null) {
                throw new IllegalArgumentException("\"" + String.valueOf(this.column) + "\" must not be null");
            }
        }
    }

    record NotNullTableConstraint(ColumnIdent column, Input<?> input) implements TableConstraint
    {
        @Override
        public void verify(Object[] values) {
            Object value = this.input.value();
            if (value == null) {
                throw new IllegalArgumentException("\"" + String.valueOf(this.column) + "\" must not be null");
            }
        }
    }

    record CheckGeneratedValue(Input<?> input, GeneratedReference ref) implements ColumnConstraint
    {
        @Override
        public void verify(Object providedValue) {
            DataType<?> valueType = this.ref.valueType();
            Object generatedValue = this.input.value();
            int compare = Comparator.nullsFirst(valueType).compare(valueType.sanitizeValue(generatedValue), valueType.sanitizeValue(providedValue));
            if (compare != 0) {
                throw new IllegalArgumentException("Given value " + String.valueOf(providedValue) + " for generated column " + String.valueOf(this.ref.column()) + " does not match calculation " + this.ref.formattedGeneratedExpression() + " = " + String.valueOf(generatedValue));
            }
        }
    }

    public static interface ColumnConstraint {
        public void verify(Object var1);
    }

    static interface TableConstraint {
        public void verify(Object[] var1);
    }

    record MultiCheck(List<ColumnConstraint> checks) implements ColumnConstraint
    {
        @Override
        public void verify(Object providedValue) {
            for (ColumnConstraint check : this.checks) {
                check.verify(providedValue);
            }
        }

        public static ColumnConstraint merge(ColumnConstraint check1, ColumnConstraint check2) {
            if (check1 instanceof MultiCheck) {
                MultiCheck multiCheck = (MultiCheck)check1;
                multiCheck.checks.add(check2);
                return check1;
            }
            ArrayList<ColumnConstraint> checks = new ArrayList<ColumnConstraint>(2);
            checks.add(check1);
            checks.add(check2);
            return new MultiCheck(checks);
        }
    }
}

