/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.data.Input;
import io.crate.exceptions.ConversionException;
import io.crate.execution.dml.DynamicIndexer;
import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.TranslogWriter;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.ObjectType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectIndexer
implements ValueIndexer<Map<String, Object>> {
    private final ColumnIdent column;
    private final Map<String, Child> children = new HashMap<String, Child>();
    private final Function<ColumnIdent, Reference> getRef;
    private final RelationName table;
    private final Reference ref;
    private final String unknownColumnPrefix;

    public ObjectIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
        this.table = table;
        this.ref = ref;
        this.getRef = getRef;
        this.unknownColumnPrefix = ref.oid() != Metadata.COLUMN_OID_UNASSIGNED ? "_u_" : "";
        this.column = ref.column();
        ObjectType objectType = (ObjectType)ArrayType.unnest(ref.valueType());
        for (Map.Entry<String, DataType<?>> entry : objectType.innerTypes().entrySet()) {
            String innerName = entry.getKey();
            DataType<?> value = entry.getValue();
            ColumnIdent child = this.column.getChild(innerName);
            Reference childRef = getRef.apply(child);
            if (childRef == null) continue;
            ValueIndexer<Object> indexer = childRef.granularity() == RowGranularity.PARTITION ? null : value.valueIndexer(table, childRef, getRef);
            this.children.put(innerName, new Child(childRef, indexer));
        }
    }

    @Override
    public void indexValue(@NotNull Map<String, Object> value, IndexDocumentBuilder docBuilder) throws IOException {
        TranslogWriter translogWriter = docBuilder.translogWriter();
        translogWriter.startObject();
        for (Map.Entry<String, Child> entry : this.children.entrySet()) {
            ValueIndexer<Object> valueIndexer;
            Object synth;
            String innerName = entry.getKey();
            Child child = entry.getValue();
            if (!value.containsKey(innerName) && (synth = docBuilder.getSyntheticValue(child.ident())) != null) {
                value.put(innerName, synth);
            }
            Object innerValue = value.get(innerName);
            docBuilder.checkColumnConstraint(child.ident(), innerValue);
            if (innerValue == null || (valueIndexer = child.indexer) == null) continue;
            innerValue = child.reference.valueType().sanitizeValue(innerValue);
            docBuilder.translogWriter().writeFieldName(child.reference.storageIdentLeafName());
            valueIndexer.indexValue(innerValue, docBuilder);
            value.put(innerName, innerValue);
        }
        HashMap<String, Object> columnsToStore = new HashMap<String, Object>();
        value.forEach((k, v) -> {
            if (!this.children.containsKey(k)) {
                translogWriter.writeFieldName(this.unknownColumnPrefix + k);
                translogWriter.writeValue(v);
                columnsToStore.put((String)k, v);
            }
            if (v == null) {
                columnsToStore.put((String)k, null);
            }
        });
        if (docBuilder.maybeAddStoredField()) {
            if (!columnsToStore.isEmpty()) {
                docBuilder.addField((IndexableField)new StoredField(this.ref.storageIdentLeafName(), this.toBytes(columnsToStore, docBuilder.getTableVersionCreated()).toBytesRef()));
            } else if (value.isEmpty()) {
                docBuilder.addField((IndexableField)new StoredField(this.ref.storageIdentLeafName(), this.toBytes(value, docBuilder.getTableVersionCreated()).toBytesRef()));
            }
        }
        translogWriter.endObject();
    }

    private BytesReference toBytes(Map<String, Object> v, Version version) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.setVersion(version);
            out.writeMap(v, StreamOutput::writeString, StreamOutput::writeGenericValue);
            BytesReference bytesReference = out.bytes();
            out.close();
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void collectSchemaUpdates(@Nullable Map<String, Object> value, Consumer<? super Reference> onDynamicColumn, ValueIndexer.Synthetics synthetics) throws IOException {
        for (Map.Entry<String, Child> entry : this.children.entrySet()) {
            String innerName = entry.getKey();
            Child child = entry.getValue();
            Object innerValue = null;
            if (value == null || !value.containsKey(innerName)) {
                Input<Object> synthetic = synthetics.get(child.ident());
                if (synthetic != null) {
                    innerValue = synthetic.value();
                }
            } else {
                innerValue = value.get(innerName);
            }
            if (child.indexer == null) continue;
            DataType<?> type = child.reference.valueType();
            try {
                innerValue = type.sanitizeValue(innerValue);
            }
            catch (ConversionException e) {
                throw e;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(innerValue, type);
            }
            child.indexer.collectSchemaUpdates(innerValue, onDynamicColumn, synthetics);
        }
        if (value != null) {
            this.addNewColumns(value, onDynamicColumn, synthetics);
        }
    }

    @Override
    public void updateTargets(Function<ColumnIdent, Reference> getRef) {
        ColumnIdent objectColumn = this.ref.column();
        Reference updatedSelf = getRef.apply(objectColumn);
        ObjectType objectType = (ObjectType)ArrayType.unnest(updatedSelf.valueType());
        for (Map.Entry<String, Child> entry : this.children.entrySet()) {
            Child child = entry.getValue();
            Reference newChildRef = getRef.apply(child.ident());
            if (!Objects.equals(child.reference, newChildRef)) {
                ValueIndexer<Object> indexer = newChildRef.granularity() == RowGranularity.PARTITION ? null : newChildRef.valueType().valueIndexer(this.table, newChildRef, getRef);
                this.children.put(entry.getKey(), new Child(newChildRef, indexer));
            }
            child.indexer.updateTargets(getRef);
        }
        for (String innerColumn : objectType.innerTypes().keySet()) {
            if (this.children.containsKey(innerColumn)) continue;
            Reference childRef = getRef.apply(objectColumn.getChild(innerColumn));
            ValueIndexer<Object> childIndexer = childRef.valueType().valueIndexer(this.table, childRef, getRef);
            this.children.put(innerColumn, new Child(childRef, childIndexer));
        }
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }

    private void addNewColumns(Map<String, Object> value, Consumer<? super Reference> onDynamicColumn, ValueIndexer.Synthetics synthetics) throws IOException {
        ColumnPolicy columnPolicy = this.ref.valueType().columnPolicy();
        if (columnPolicy == ColumnPolicy.IGNORED) {
            return;
        }
        boolean isStrict = columnPolicy == ColumnPolicy.STRICT;
        int position = -1;
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String innerName = entry.getKey();
            Object innerValue = entry.getValue();
            if (this.children.containsKey(innerName) || innerValue == null) continue;
            if (isStrict) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot add column `%s` to strict object `%s`", innerName, this.ref.column()));
            }
            DataType<?> type = DynamicIndexer.guessType(innerValue);
            Reference newColumn = DynamicIndexer.buildReference(new ReferenceIdent(this.table, this.column.getChild(innerName)), type, position, Metadata.COLUMN_OID_UNASSIGNED);
            --position;
            onDynamicColumn.accept(newColumn);
            ValueIndexer<?> valueIndexer = type.valueIndexer(this.table, newColumn, this.getRef);
            innerValue = type.sanitizeValue(innerValue);
            valueIndexer.collectSchemaUpdates(innerValue, onDynamicColumn, synthetics);
        }
    }

    private record Child(Reference reference, ValueIndexer<Object> indexer) {
        ColumnIdent ident() {
            return this.reference.column();
        }
    }
}

