/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.TranslogWriter;
import io.crate.execution.dml.XContentTranslogWriter;
import org.elasticsearch.common.bytes.BytesReference;

class SidecarTranslogWriter
implements TranslogWriter {
    private final TranslogWriter inner;
    private final TranslogWriter sidecar;

    SidecarTranslogWriter(TranslogWriter inner, String oid) {
        this.inner = inner;
        this.sidecar = new XContentTranslogWriter();
        this.sidecar.writeFieldName(oid);
    }

    @Override
    public void startArray() {
        this.inner.startArray();
        this.sidecar.startArray();
    }

    @Override
    public void endArray() {
        this.inner.endArray();
        this.sidecar.endArray();
    }

    @Override
    public void startObject() {
        this.inner.startObject();
        this.sidecar.startObject();
    }

    @Override
    public void endObject() {
        this.inner.endObject();
        this.sidecar.endObject();
    }

    @Override
    public void writeFieldName(String fieldName) {
        this.inner.writeFieldName(fieldName);
        this.sidecar.writeFieldName(fieldName);
    }

    @Override
    public void writeNull() {
        this.inner.writeNull();
        this.sidecar.writeNull();
    }

    @Override
    public void writeValue(Object value) {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public BytesReference bytes() {
        return this.sidecar.bytes();
    }
}

