/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.TranslogWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class XContentTranslogWriter
implements TranslogWriter {
    private final XContentBuilder builder;
    private final BytesStreamOutput output = new BytesStreamOutput();

    public XContentTranslogWriter() {
        try {
            this.builder = XContentFactory.json((OutputStream)this.output);
            this.builder.startObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void startArray() {
        TranslogWriter.uncheck(() -> ((XContentBuilder)this.builder).startArray());
    }

    @Override
    public void endArray() {
        TranslogWriter.uncheck(() -> ((XContentBuilder)this.builder).endArray());
    }

    @Override
    public void startObject() {
        TranslogWriter.uncheck(() -> ((XContentBuilder)this.builder).startObject());
    }

    @Override
    public void endObject() {
        TranslogWriter.uncheck(() -> ((XContentBuilder)this.builder).endObject());
    }

    @Override
    public void writeNull() {
        TranslogWriter.uncheck(() -> ((XContentBuilder)this.builder).nullValue());
    }

    @Override
    public void writeFieldName(String fieldName) {
        TranslogWriter.uncheck(() -> this.builder.field(fieldName));
    }

    @Override
    public void writeValue(Object value) {
        TranslogWriter.uncheck(() -> this.builder.value(value));
    }

    @Override
    public BytesReference bytes() {
        TranslogWriter.uncheck(() -> ((XContentBuilder)this.builder).endObject());
        this.builder.close();
        return this.output.bytes();
    }
}

