/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.common.collections.Lists;
import io.crate.common.exceptions.Exceptions;
import io.crate.execution.ddl.tables.AddColumnRequest;
import io.crate.execution.ddl.tables.TransportAddColumnAction;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.Indexer;
import io.crate.execution.dml.RawIndexer;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.TransportShardAction;
import io.crate.execution.dml.UpsertReplicaRequest;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.dml.upsert.UpdateToInsert;
import io.crate.execution.engine.collect.PKLookupOperation;
import io.crate.execution.jobs.TasksService;
import io.crate.expression.reference.Doc;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.Term;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class TransportShardUpsertAction
extends TransportShardAction<ShardUpsertRequest, UpsertReplicaRequest, ShardUpsertRequest.Item, UpsertReplicaRequest.Item> {
    private static final int MAX_RETRY_LIMIT = 100000;
    private final Schemas schemas;
    private final NodeContext nodeCtx;
    private final TransportAddColumnAction addColumnAction;

    @Inject
    public TransportShardUpsertAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, TransportAddColumnAction addColumnAction, TasksService tasksService, IndicesService indicesService, ShardStateAction shardStateAction, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx) {
        super(settings, "internal:crate:sql/data/write", transportService, clusterService, indicesService, tasksService, threadPool, shardStateAction, circuitBreakerService, ShardUpsertRequest::new, UpsertReplicaRequest::readFrom);
        this.nodeCtx = nodeCtx;
        this.schemas = nodeCtx.schemas();
        this.addColumnAction = addColumnAction;
        tasksService.addListener(this);
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<UpsertReplicaRequest, ShardResponse> processRequestItems(IndexShard indexShard, ShardUpsertRequest request, AtomicBoolean killed) {
        ColumnIdent firstColumnIdent;
        Indexer indexer;
        ShardResponse shardResponse = new ShardResponse(request.returnValues());
        String indexName = request.index();
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.getTableInfo(RelationName.fromIndexName(indexName));
        TransactionContext txnCtx = TransactionContext.of(request.sessionSettings());
        ArrayList<Reference> insertColumns = new ArrayList<Reference>();
        if (request.insertColumns() != null) {
            for (Reference ref : request.insertColumns()) {
                Reference updatedRef = tableInfo.getReference(ref.column());
                insertColumns.add(updatedRef == null ? ref : updatedRef);
            }
        }
        UpdateToInsert updateToInsert = null;
        if (request.updateColumns() != null && request.updateColumns().length > 0) {
            updateToInsert = new UpdateToInsert(this.nodeCtx, txnCtx, tableInfo, request.updateColumns(), insertColumns);
            indexer = new Indexer(request.index(), tableInfo, indexShard.getVersionCreated(), txnCtx, this.nodeCtx, updateToInsert.columns(), request.returnValues());
            firstColumnIdent = indexer.columns().getFirst().column();
        } else {
            indexer = new Indexer(indexName, tableInfo, indexShard.getVersionCreated(), txnCtx, this.nodeCtx, insertColumns, request.returnValues());
            firstColumnIdent = indexer.columns().getFirst().column();
        }
        RawIndexer rawIndexer = null;
        if (firstColumnIdent.equals(SysColumns.RAW)) {
            rawIndexer = new RawIndexer(indexName, tableInfo, indexShard.getVersionCreated(), txnCtx, this.nodeCtx, request.returnValues(), List.of());
        }
        Translog.Location translogLocation = null;
        ArrayList<UpsertReplicaRequest.Item> replicaItems = new ArrayList<UpsertReplicaRequest.Item>();
        UpsertReplicaRequest replicaRequest = new UpsertReplicaRequest(request.shardId(), request.jobId(), request.sessionSettings(), List.copyOf(indexer.insertColumns()), replicaItems);
        for (ShardUpsertRequest.Item item : request.items()) {
            if (shardResponse.failure() != null) continue;
            int location = item.location();
            if (killed.get()) {
                shardResponse.failure(new InterruptedException());
                continue;
            }
            try {
                IndexItemResult indexItemResult = this.indexItem(indexer, request, item, indexShard, tableInfo, updateToInsert, rawIndexer);
                if (indexItemResult == null) continue;
                Engine.IndexResult result = indexItemResult.result;
                if (result.getTranslogLocation() != null) {
                    shardResponse.add(location);
                    translogLocation = result.getTranslogLocation();
                }
                if (indexItemResult.returnValues != null) {
                    shardResponse.addResultRows(indexItemResult.returnValues);
                }
                UpsertReplicaRequest.Item replicaItem = new UpsertReplicaRequest.Item(item.id(), indexItemResult.replicaInsertValues(), item.pkValues(), result.getSeqNo(), result.getTerm(), result.getVersion());
                replicaItems.add(replicaItem);
            }
            catch (Exception e) {
                if (this.retryPrimaryException(e)) {
                    throw Exceptions.toRuntimeException((Throwable)e);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to execute upsert on nodeName={}, shardId={} id={} error={}", (Object)this.clusterService.localNode().getName(), (Object)request.shardId(), (Object)item.id(), (Object)e);
                }
                if (!request.continueOnError()) {
                    shardResponse.failure(e);
                    break;
                }
                shardResponse.add(location, item.id(), e, e instanceof VersionConflictEngineException);
            }
            catch (AssertionError e) {
                shardResponse.failure(Exceptions.toException((Throwable)((Object)e)));
                break;
            }
        }
        return new TransportWriteAction.WritePrimaryResult<UpsertReplicaRequest, ShardResponse>(replicaRequest, shardResponse, translogLocation, null, indexShard);
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult processRequestItemsOnReplica(IndexShard indexShard, UpsertReplicaRequest request) throws IOException {
        RawIndexer rawIndexer;
        Indexer indexer;
        List<Reference> columns = request.columns();
        Translog.Location location = null;
        String indexName = request.index();
        boolean traceEnabled = this.logger.isTraceEnabled();
        RelationName relationName = RelationName.fromIndexName(indexName);
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.getTableInfo(relationName);
        TransactionContext txnCtx = TransactionContext.of(request.sessionSettings());
        List targetColumns = Lists.map(columns, ref -> {
            Reference updatedRef = tableInfo.getReference(ref.column());
            return updatedRef == null ? ref : updatedRef;
        });
        if (columns.get(0).column().equals(SysColumns.RAW)) {
            indexer = null;
            rawIndexer = new RawIndexer(indexName, tableInfo, indexShard.getVersionCreated(), txnCtx, this.nodeCtx, null, targetColumns.subList(1, targetColumns.size()));
        } else {
            rawIndexer = null;
            indexer = new Indexer(indexName, tableInfo, indexShard.getVersionCreated(), txnCtx, this.nodeCtx, targetColumns, null);
        }
        for (UpsertReplicaRequest.Item item : request.items()) {
            List<Reference> newColumns;
            if (item.seqNo() == -3L) {
                if (!traceEnabled) continue;
                this.logger.trace("[{} (R)] Document with id={}, marked as skip_on_replica", (Object)indexShard.shardId(), (Object)item.id());
                continue;
            }
            long startTime = System.nanoTime();
            List<Reference> list = newColumns = rawIndexer != null ? rawIndexer.collectSchemaUpdates(item) : indexer.collectSchemaUpdates(item);
            if (!newColumns.isEmpty()) {
                this.logger.trace("Mappings are not available on the replica columns={}", newColumns);
                throw new TransportReplicationAction.RetryOnReplicaException(indexShard.shardId(), "Mappings are not available on the replica yet, triggered update: " + String.valueOf(newColumns));
            }
            ParsedDocument parsedDoc = rawIndexer != null ? rawIndexer.index() : indexer.index(item);
            Term uid = new Term("_id", Uid.encodeId(item.id()));
            boolean isRetry = false;
            Engine.Index index = new Engine.Index(uid, parsedDoc, item.seqNo(), item.primaryTerm(), item.version(), null, Engine.Operation.Origin.REPLICA, startTime, -1L, isRetry, -2L, 0L);
            Engine.IndexResult result = indexShard.index(index);
            assert (result.getResultType() != Engine.Result.Type.MAPPING_UPDATE_REQUIRED) : "If parsedDoc.newColumns is empty there must be no mapping update requirement";
            location = result.getTranslogLocation();
        }
        return new TransportWriteAction.WriteReplicaResult(location, null, indexShard);
    }

    @Nullable
    private IndexItemResult indexItem(Indexer indexer, ShardUpsertRequest request, ShardUpsertRequest.Item item, IndexShard indexShard, DocTableInfo tableInfo, @Nullable UpdateToInsert updateToInsert, @Nullable RawIndexer rawIndexer) throws Exception {
        VersionConflictEngineException lastException = null;
        Object[] insertValues = item.insertValues();
        boolean tryInsertFirst = insertValues != null;
        boolean hasUpdate = item.updateAssignments() != null && item.updateAssignments().length > 0;
        long seqNo = item.seqNo();
        long primaryTerm = item.primaryTerm();
        IndexItem indexItem = item;
        for (int retryCount = 0; retryCount < 100000; ++retryCount) {
            try {
                boolean isRetry = retryCount > 0 || request.isRetry();
                AtomicLong version = new AtomicLong();
                if (tryInsertFirst) {
                    version.setPlain(request.duplicateKeyAction() == ShardUpsertRequest.DuplicateKeyAction.OVERWRITE ? -3L : -4L);
                } else {
                    DocTableInfo actualTable = tableInfo;
                    if (isRetry) {
                        actualTable = (DocTableInfo)this.schemas.getTableInfo(tableInfo.ident());
                    }
                    assert (updateToInsert != null);
                    String id = item.id();
                    indexItem = (IndexItem)PKLookupOperation.withDoc(indexShard, id, item.version(), VersionType.INTERNAL, seqNo, primaryTerm, actualTable, null, doc -> {
                        if (doc == null) {
                            throw new DocumentMissingException(indexShard.shardId(), "default", id);
                        }
                        version.setPlain(doc.getVersion());
                        return updateToInsert.convert((Doc)doc, item.updateAssignments(), insertValues);
                    });
                }
                return this.insert(indexer, request, indexItem, indexShard, isRetry, rawIndexer, version.getPlain(), item.autoGeneratedTimestamp());
            }
            catch (VersionConflictEngineException e) {
                lastException = e;
                if (request.duplicateKeyAction() == ShardUpsertRequest.DuplicateKeyAction.IGNORE) {
                    return null;
                }
                if (hasUpdate) {
                    if (tryInsertFirst) {
                        tryInsertFirst = false;
                        continue;
                    }
                    if (seqNo == -2L && item.version() == -3L) {
                        if (!this.logger.isTraceEnabled()) continue;
                        this.logger.trace("[{}] VersionConflict, retrying operation for document id={}, version={} retryCount={}", (Object)indexShard.shardId(), (Object)item.id(), (Object)item.version(), (Object)retryCount);
                        continue;
                    }
                }
                throw e;
            }
        }
        this.logger.warn("[{}] VersionConflict for document id={}, version={} exceeded retry limit of {}, will stop retrying", (Object)indexShard.shardId(), (Object)item.id(), (Object)item.version(), (Object)100000);
        throw lastException;
    }

    @VisibleForTesting
    protected IndexItemResult insert(Indexer indexer, ShardUpsertRequest request, IndexItem item, IndexShard indexShard, boolean isRetry, @Nullable RawIndexer rawIndexer, long version, long autoGeneratedTimestamp) throws Exception {
        long startTime = System.nanoTime();
        List<Reference> newColumns = rawIndexer == null ? indexer.collectSchemaUpdates(item) : rawIndexer.collectSchemaUpdates(item);
        RelationName relationName = RelationName.fromIndexName(indexShard.shardId().getIndexName());
        if (!newColumns.isEmpty()) {
            AddColumnRequest addColumnRequest = new AddColumnRequest(RelationName.fromIndexName(indexShard.shardId().getIndexName()), newColumns, Map.of(), new IntArrayList(0));
            this.addColumnAction.execute(addColumnRequest).get();
            DocTableInfo actualTable = (DocTableInfo)this.schemas.getTableInfo(relationName);
            if (rawIndexer == null) {
                indexer.updateTargets(actualTable::getReference);
            } else {
                rawIndexer.updateTargets(actualTable::getReference);
            }
        }
        ParsedDocument parsedDoc = rawIndexer == null ? indexer.index(item) : rawIndexer.index();
        Term uid = new Term("_id", Uid.encodeId(item.id()));
        assert (VersionType.INTERNAL.validateVersionForWrites(version));
        Engine.Index index = new Engine.Index(uid, parsedDoc, -2L, indexShard.getOperationPrimaryTerm(), version, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, startTime, autoGeneratedTimestamp, isRetry, item.seqNo(), item.primaryTerm());
        Engine.IndexResult result = indexShard.index(index);
        switch (result.getResultType()) {
            case SUCCESS: {
                Object[] replicaInsertValues = rawIndexer == null ? indexer.addGeneratedValues(item) : rawIndexer.addGeneratedValues(item);
                Object[] returnValues = indexer.hasReturnValues() ? indexer.returnValues(new IndexItem.StaticItem(item.id(), item.pkValues(), replicaInsertValues, result.getSeqNo(), result.getTerm())) : null;
                return new IndexItemResult(result, replicaInsertValues, returnValues);
            }
            case FAILURE: {
                Exception failure = result.getFailure();
                assert (failure != null) : "Failure must not be null if resultType is FAILURE";
                throw failure;
            }
            case MAPPING_UPDATE_REQUIRED: {
                throw new ReplicationOperation.RetryOnPrimaryException(indexShard.shardId(), "Dynamic mappings are not available on the node that holds the primary yet");
            }
        }
        throw new AssertionError((Object)"IndexResult must either succeed or fail. Required mapping updates must have been handled.");
    }

    public record IndexItemResult(Engine.IndexResult result, Object[] replicaInsertValues, @Nullable Object[] returnValues) {
    }
}

