/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.analyze.Id;
import io.crate.common.collections.Maps;
import io.crate.data.Input;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.BaseImplementationSymbolVisitor;
import io.crate.expression.reference.Doc;
import io.crate.expression.reference.DocRefResolver;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public final class UpdateToInsert {
    private final DocTableInfo table;
    private final Evaluator eval;
    private final List<Reference> updateColumns;
    private final ArrayList<Reference> columns;

    public UpdateToInsert(NodeContext nodeCtx, TransactionContext txnCtx, DocTableInfo table, String[] updateColumns, @Nullable List<Reference> insertColumns) {
        DocRefResolver refResolver = new DocRefResolver(table.partitionedBy());
        this.table = table;
        this.eval = new Evaluator(nodeCtx, txnCtx, refResolver);
        this.updateColumns = new ArrayList<Reference>(updateColumns.length);
        this.columns = new ArrayList();
        List<String> updateColumnList = Arrays.asList(updateColumns);
        boolean errorOnUnknownObjectKey = txnCtx.sessionSettings().errorOnUnknownObjectKey();
        if (insertColumns != null) {
            this.columns.addAll(insertColumns);
        }
        for (Reference reference : table.defaultExpressionColumns()) {
            if (reference.defaultExpression().isDeterministic() || this.columns.contains(reference)) continue;
            this.columns.add(reference);
        }
        for (GeneratedReference generatedReference : table.generatedColumns()) {
            if (generatedReference.isDeterministic() || this.columns.contains(generatedReference)) continue;
            this.columns.add(generatedReference);
        }
        for (Reference reference : table.columns()) {
            if (reference instanceof GeneratedReference && !updateColumnList.contains(reference.column().fqn()) || this.columns.contains(reference)) continue;
            this.columns.add(reference);
        }
        for (Iterator<Reference> iterator : updateColumns) {
            ColumnIdent column = ColumnIdent.fromPath(iterator);
            Reference existingRef = table.getReference(column);
            if (existingRef == null) {
                DynamicReference reference = table.getDynamic(column, true, errorOnUnknownObjectKey);
                if (column.isRoot()) {
                    this.columns.add(reference);
                    this.updateColumns.add(reference);
                    continue;
                }
                ColumnIdent root = column.getRoot();
                Reference rootReference = table.getReference(root);
                if (rootReference == null) {
                    throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot add new child `%s` if parent column is missing", column));
                }
                this.updateColumns.add(reference);
                continue;
            }
            this.updateColumns.add(existingRef);
        }
    }

    public IndexItem convert(Doc doc, Symbol[] updateAssignments, Object[] excludedValues) {
        Values values = new Values(doc, excludedValues);
        Object[] insertValues = new Object[this.columns.size()];
        Iterator<Reference> it = this.columns.iterator();
        int i = 0;
        while (it.hasNext()) {
            Reference ref = it.next();
            int updateIdx = this.updateColumns.indexOf(ref);
            if (updateIdx >= 0) {
                Symbol symbol = updateAssignments[updateIdx];
                Object value = ((Input)symbol.accept(this.eval, values)).value();
                assert (ref.column().isRoot()) : "If updateColumns.indexOf(reference-from-table.columns()) is >= 0 it must be a top level reference";
                insertValues[i] = value;
            } else {
                GeneratedReference genRef;
                insertValues[i] = ref instanceof GeneratedReference && !(genRef = (GeneratedReference)ref).isDeterministic() ? null : (ref.defaultExpression() != null && !ref.defaultExpression().isDeterministic() ? null : ((Input)ref.accept(this.eval, values)).value());
            }
            ++i;
        }
        for (i = 0; i < this.updateColumns.size(); ++i) {
            Reference updateColumn = this.updateColumns.get(i);
            ColumnIdent column = updateColumn.column();
            if (column.isRoot()) continue;
            ColumnIdent root = column.getRoot();
            int idx = Reference.indexOf(this.columns, root);
            assert (idx > -1) : "Root of updateColumns must exist in table columns";
            Symbol assignment = updateAssignments[i];
            Object value = ((Input)assignment.accept(this.eval, values)).value();
            ColumnIdent targetPath = column.shiftRight();
            HashMap source = (HashMap)insertValues[idx];
            if (source == null) {
                insertValues[idx] = source = new HashMap();
            }
            Maps.mergeInto(source, (String)targetPath.name(), targetPath.path(), (Object)value);
        }
        return new IndexItem.StaticItem(doc.getId(), Id.decode(this.table.primaryKey(), doc.getId()), insertValues, doc.getSeqNo(), doc.getPrimaryTerm());
    }

    public List<Reference> columns() {
        return this.columns;
    }

    private static class Evaluator
    extends BaseImplementationSymbolVisitor<Values> {
        private final ReferenceResolver<CollectExpression<Doc, ?>> refResolver;

        private Evaluator(NodeContext nodeCtx, TransactionContext txnCtx, ReferenceResolver<CollectExpression<Doc, ?>> refResolver) {
            super(txnCtx, nodeCtx);
            this.refResolver = refResolver;
        }

        @Override
        public Input<?> visitInputColumn(InputColumn inputColumn, Values context) {
            return Literal.ofUnchecked(inputColumn.valueType(), context.excludedValues[inputColumn.index()]);
        }

        @Override
        public Input<?> visitReference(Reference symbol, Values values) {
            CollectExpression<Doc, ?> expr = this.refResolver.getImplementation(symbol);
            expr.setNextRow(values.doc);
            return expr;
        }
    }

    record Values(Doc doc, Object[] excludedValues) {
    }

    public record Update(List<String> pkValues, Object[] insertValues, long version) {
    }
}

