/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.planner.distribution.DistributionInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamOutput;

public class TableFunctionCollectPhase
extends AbstractProjectionsPhase
implements CollectPhase {
    private final TableFunctionImplementation<?> functionImplementation;
    private final List<Literal<?>> functionArguments;
    private final List<Symbol> outputs;
    private final Symbol where;
    private final String nodeId;
    private DistributionInfo distributionInfo = DistributionInfo.DEFAULT_BROADCAST;

    public TableFunctionCollectPhase(UUID jobId, int phaseId, String nodeId, TableFunctionImplementation<?> functionImplementation, List<Literal<?>> functionArguments, List<Symbol> outputs, Symbol where) {
        super(jobId, phaseId, "tableFunction", List.of());
        this.nodeId = nodeId;
        this.functionImplementation = functionImplementation;
        this.functionArguments = functionArguments;
        this.outputs = outputs;
        this.where = where;
        this.outputTypes = Symbols.typeView(outputs);
    }

    public Symbol where() {
        return this.where;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.TABLE_FUNCTION_COLLECT;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitTableFunctionCollect(this, context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    public List<Literal<?>> functionArguments() {
        return this.functionArguments;
    }

    public TableFunctionImplementation<?> functionImplementation() {
        return this.functionImplementation;
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    @Override
    public String name() {
        return "tableFunction";
    }

    @Override
    public Collection<String> nodeIds() {
        return List.of(this.nodeId);
    }

    @Override
    public List<Symbol> toCollect() {
        return this.outputs;
    }
}

