/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.data.Row;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CorrelatedJoinProjection
extends Projection {
    private final List<Symbol> outputs;
    private final LogicalPlan subQueryPlan;
    private final SelectSymbol correlatedSubQuery;
    private final PlannerContext plannerContext;
    private final SubQueryResults subQueryResults;
    private final Row params;
    private final List<Symbol> inputPlanOutputs;
    private final DependencyCarrier executor;

    public CorrelatedJoinProjection(DependencyCarrier executor, LogicalPlan subQueryPlan, SelectSymbol correlatedSubQuery, PlannerContext plannerContext, SubQueryResults subQueryResults, Row params, List<Symbol> inputPlanOutputs, List<Symbol> outputs) {
        this.executor = executor;
        this.subQueryPlan = subQueryPlan;
        this.correlatedSubQuery = correlatedSubQuery;
        this.plannerContext = plannerContext;
        this.subQueryResults = subQueryResults;
        this.params = params;
        this.inputPlanOutputs = inputPlanOutputs;
        this.outputs = outputs;
    }

    public LogicalPlan subQueryPlan() {
        return this.subQueryPlan;
    }

    public SelectSymbol correlatedSubQuery() {
        return this.correlatedSubQuery;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    public SubQueryResults subQueryResults() {
        return this.subQueryResults;
    }

    public Row params() {
        return this.params;
    }

    public List<Symbol> inputPlanOutputs() {
        return this.inputPlanOutputs;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.CORRELATED_JOIN;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitCorrelatedJoin(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Cannot stream correlated join projection");
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    public DependencyCarrier executor() {
        return this.executor;
    }
}

