/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.Projection;
import io.crate.metadata.RowGranularity;
import java.util.ArrayList;
import java.util.Collection;

public class Projections {
    public static Collection<? extends Projection> shardProjections(Collection<? extends Projection> projections) {
        ArrayList<Projection> result = new ArrayList<Projection>(projections.size());
        for (Projection projection : projections) {
            if (!Projection.IS_SHARD_PROJECTION.test(projection)) continue;
            result.add(projection);
        }
        return result;
    }

    public static Collection<? extends Projection> nodeProjections(Collection<? extends Projection> projections) {
        ArrayList<Projection> result = new ArrayList<Projection>(projections.size());
        for (Projection projection : projections) {
            if (!Projection.IS_NODE_PROJECTION.test(projection)) continue;
            result.add(projection);
        }
        return result;
    }

    public static boolean hasAnyShardProjections(Iterable<? extends Projection> projections) {
        for (Projection projection : projections) {
            if (projection.requiredGranularity() != RowGranularity.SHARD) continue;
            return true;
        }
        return false;
    }
}

