/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.SourceIndexWriterProjection;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class SourceIndexWriterReturnSummaryProjection
extends SourceIndexWriterProjection {
    private final InputColumn sourceUri;
    private final InputColumn sourceUriFailure;
    private final InputColumn sourceParsingFailure;
    private final InputColumn lineNumber;

    public SourceIndexWriterReturnSummaryProjection(RelationName relationName, @Nullable String partitionIdent, Reference rawSourceReference, InputColumn rawSourcePtr, List<ColumnIdent> primaryKeys, List<Symbol> partitionedBySymbols, @Nullable ColumnIdent clusteredByColumn, Settings settings, @Nullable String[] excludes, List<Symbol> idSymbols, @Nullable Symbol clusteredBySymbol, List<? extends Symbol> outputs, boolean autoCreateIndices, InputColumn sourceUri, InputColumn sourceUriFailure, InputColumn sourceParsingFailure, InputColumn lineNumber) {
        super(relationName, partitionIdent, rawSourceReference, rawSourcePtr, primaryKeys, partitionedBySymbols, clusteredByColumn, settings, excludes, idSymbols, clusteredBySymbol, outputs, autoCreateIndices);
        this.sourceUri = sourceUri;
        this.sourceUriFailure = sourceUriFailure;
        this.sourceParsingFailure = sourceParsingFailure;
        this.lineNumber = lineNumber;
    }

    SourceIndexWriterReturnSummaryProjection(StreamInput in) throws IOException {
        super(in);
        this.sourceUri = (InputColumn)Symbol.fromStream(in);
        this.sourceUriFailure = (InputColumn)Symbol.fromStream(in);
        this.lineNumber = (InputColumn)Symbol.fromStream(in);
        this.sourceParsingFailure = in.getVersion().before(Version.V_4_7_1) ? null : (InputColumn)Symbol.fromStream(in);
    }

    public InputColumn sourceUri() {
        return this.sourceUri;
    }

    public InputColumn sourceUriFailure() {
        return this.sourceUriFailure;
    }

    @Nullable
    public InputColumn sourceParsingFailure() {
        return this.sourceParsingFailure;
    }

    public InputColumn lineNumber() {
        return this.lineNumber;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.INDEX_WRITER_RETURN_SUMMARY;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Symbol.toStream(this.sourceUri, out);
        Symbol.toStream(this.sourceUriFailure, out);
        Symbol.toStream(this.lineNumber, out);
        if (out.getVersion().after(Version.V_4_7_1)) {
            Symbol.toStream(this.sourceParsingFailure, out);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceIndexWriterReturnSummaryProjection that = (SourceIndexWriterReturnSummaryProjection)o;
        return Objects.equals(this.sourceUri, that.sourceUri) && Objects.equals(this.sourceUriFailure, that.sourceUriFailure) && Objects.equals(this.sourceParsingFailure, that.sourceParsingFailure) && Objects.equals(this.lineNumber, that.lineNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceUri, this.sourceUriFailure, this.sourceParsingFailure, this.lineNumber);
    }
}

