/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.AsyncFlatMapBatchIterator;
import io.crate.data.AsyncFlatMapper;
import io.crate.data.BatchIterator;
import io.crate.data.BiArrayRow;
import io.crate.data.CloseableIterator;
import io.crate.data.CollectingRowConsumer;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.FirstColumnConsumers;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;

public final class CorrelatedJoinProjector
implements Projector {
    private final LogicalPlan subQueryPlan;
    private final PlannerContext plannerContext;
    private final DependencyCarrier executor;
    private final SubQueryResults subQueryResults;
    private final Row params;
    private final SelectSymbol correlatedSubQuery;

    public CorrelatedJoinProjector(LogicalPlan subQueryPlan, SelectSymbol correlatedSubQuery, PlannerContext plannerContext, DependencyCarrier executor, SubQueryResults subQueryResults, Row params, List<Symbol> inputPlanOutputs) {
        this.correlatedSubQuery = correlatedSubQuery;
        this.subQueryPlan = subQueryPlan;
        this.plannerContext = plannerContext;
        this.executor = executor;
        this.subQueryResults = subQueryResults.forCorrelation(correlatedSubQuery, inputPlanOutputs);
        this.params = params;
    }

    public BatchIterator<Row> apply(BatchIterator<Row> it) {
        BindAndExecuteSubQuery bindAndExecuteSubQuery = new BindAndExecuteSubQuery();
        return new AsyncFlatMapBatchIterator(it, (AsyncFlatMapper)bindAndExecuteSubQuery);
    }

    private final class BindAndExecuteSubQuery
    implements AsyncFlatMapper<Row, Row> {
        private final Collector<Row, ?, ?> collector;

        public BindAndExecuteSubQuery() {
            this.collector = FirstColumnConsumers.getCollector(CorrelatedJoinProjector.this.correlatedSubQuery.getResultType(), CorrelatedJoinProjector.this.correlatedSubQuery.innerType(), RamAccounting.NO_ACCOUNTING);
        }

        public CompletableFuture<? extends CloseableIterator<Row>> apply(Row inputRow, boolean isLastCall) {
            try {
                CorrelatedJoinProjector.this.subQueryResults.bindOuterColumnInputRow(inputRow);
                CollectingRowConsumer rowConsumer = new CollectingRowConsumer(this.collector);
                CorrelatedJoinProjector.this.subQueryPlan.execute(CorrelatedJoinProjector.this.executor, PlannerContext.forSubPlan(CorrelatedJoinProjector.this.plannerContext), (RowConsumer)rowConsumer, CorrelatedJoinProjector.this.params, CorrelatedJoinProjector.this.subQueryResults);
                Object[] secondCells = new Object[1];
                BiArrayRow outputRow = new BiArrayRow(inputRow.materialize(), secondCells);
                return rowConsumer.completionFuture().thenApply(result -> {
                    secondCells[0] = result;
                    return CloseableIterator.fromIterator(List.of(outputRow).iterator());
                });
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        }
    }
}

