/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.engine.JobLauncher;
import io.crate.execution.jobs.JobSetup;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsNodeAction;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.jobs.transport.JobAction;
import io.crate.execution.jobs.transport.JobRequest;
import io.crate.execution.jobs.transport.JobResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeRequest;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public final class PhasesTaskFactory {
    private final ClusterService clusterService;
    private final JobSetup jobSetup;
    private final TasksService tasksService;
    private final IndicesService indicesService;
    private final ActionExecutor<NodeRequest<JobRequest>, JobResponse> jobAction;
    private final ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction;
    private final Executor searchExecutor;

    @Inject
    public PhasesTaskFactory(ClusterService clusterService, ThreadPool threadPool, JobSetup jobSetup, TasksService tasksService, IndicesService indicesService, Node node) {
        this.clusterService = clusterService;
        this.jobSetup = jobSetup;
        this.tasksService = tasksService;
        this.indicesService = indicesService;
        this.jobAction = req -> node.client().execute(JobAction.INSTANCE, req);
        this.killNodeAction = req -> node.client().execute(KillJobsNodeAction.INSTANCE, req);
        this.searchExecutor = threadPool.executor("search");
    }

    public JobLauncher create(UUID jobId, List<NodeOperationTree> nodeOperationTreeList) {
        return this.create(jobId, nodeOperationTreeList, false);
    }

    public JobLauncher create(UUID jobId, List<NodeOperationTree> nodeOperationTreeList, boolean enableProfiling) {
        return new JobLauncher(jobId, this.clusterService, this.jobSetup, this.tasksService, this.indicesService, this.jobAction, this.killNodeAction, nodeOperationTreeList, enableProfiling, this.searchExecutor);
    }
}

