/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.execution.engine.aggregation.statistics.StandardDeviation;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class StandardDeviationAggregation
extends AggregationFunction<StandardDeviation, Double> {
    public static final String NAME = "stddev";
    private static final List<DataType<?>> SUPPORTED_TYPES;
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        for (DataType<?> supportedType : SUPPORTED_TYPES) {
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), StandardDeviationAggregation::new);
        }
    }

    public StandardDeviationAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public StandardDeviation newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)StdDevStateType.INSTANCE.fixedSize());
        return new StandardDeviation();
    }

    @Override
    public StandardDeviation iterate(RamAccounting ramAccounting, MemoryManager memoryManager, StandardDeviation state, Input<?> ... args) throws CircuitBreakingException {
        Number value;
        if (state != null && (value = (Number)args[0].value()) != null) {
            state.increment(value.doubleValue());
        }
        return state;
    }

    @Override
    public StandardDeviation reduce(RamAccounting ramAccounting, StandardDeviation state1, StandardDeviation state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        state1.merge(state2);
        return state1;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public StandardDeviation removeFromAggregatedState(RamAccounting ramAccounting, StandardDeviation previousAggState, Input<?>[] stateToRemove) {
        Number value;
        if (previousAggState != null && (value = (Number)stateToRemove[0].value()) != null) {
            previousAggState.decrement(value.doubleValue());
        }
        return previousAggState;
    }

    @Override
    public Double terminatePartial(RamAccounting ramAccounting, StandardDeviation state) {
        double result = state.result();
        return Double.isNaN(result) ? null : Double.valueOf(result);
    }

    @Override
    public DataType<?> partialType() {
        return StdDevStateType.INSTANCE;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        switch (reference.valueType().id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return new SortedNumericDocValueAggregator<StandardDeviation>(reference.storageIdent(), (ramAccounting, memoryManager, minNodeVersion) -> {
                    ramAccounting.addBytes((long)StdDevStateType.INSTANCE.fixedSize());
                    return new StandardDeviation();
                }, (values, state) -> state.increment(values.nextValue()));
            }
            case 7: {
                return new SortedNumericDocValueAggregator<StandardDeviation>(reference.storageIdent(), (ramAccounting, memoryManager, minNodeVersion) -> {
                    ramAccounting.addBytes((long)StdDevStateType.INSTANCE.fixedSize());
                    return new StandardDeviation();
                }, (values, state) -> {
                    float value = NumericUtils.sortableIntToFloat((int)((int)values.nextValue()));
                    state.increment(value);
                });
            }
            case 6: {
                return new SortedNumericDocValueAggregator<StandardDeviation>(reference.storageIdent(), (ramAccounting, memoryManager, minNodeVersion) -> {
                    ramAccounting.addBytes((long)StdDevStateType.INSTANCE.fixedSize());
                    return new StandardDeviation();
                }, (values, state) -> {
                    double value = NumericUtils.sortableLongToDouble((long)values.nextValue());
                    state.increment(value);
                });
            }
        }
        return null;
    }

    static {
        DataTypes.register(8192, in -> StdDevStateType.INSTANCE);
        SUPPORTED_TYPES = Lists.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, (Object)DataTypes.TIMESTAMPZ);
    }

    public static class StdDevStateType
    extends DataType<StandardDeviation>
    implements Streamer<StandardDeviation>,
    FixedWidthType {
        public static final StdDevStateType INSTANCE = new StdDevStateType();
        public static final int ID = 8192;

        @Override
        public int id() {
            return 8192;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "stddev_state";
        }

        @Override
        public Streamer<StandardDeviation> streamer() {
            return this;
        }

        @Override
        public StandardDeviation sanitizeValue(Object value) {
            return (StandardDeviation)value;
        }

        @Override
        public int compare(StandardDeviation val1, StandardDeviation val2) {
            return val1.compareTo(val2);
        }

        @Override
        public int fixedSize() {
            return 192;
        }

        @Override
        public StandardDeviation readValueFrom(StreamInput in) throws IOException {
            return new StandardDeviation(in);
        }

        @Override
        public void writeValueTo(StreamOutput out, StandardDeviation v) throws IOException {
            v.writeTo(out);
        }

        @Override
        public long valueBytes(StandardDeviation value) {
            return this.fixedSize();
        }
    }
}

