/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.analyze.OrderBy;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.OrderByCollectorExpression;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.types.DataType;

public class DocInputFactory {
    private final ReferenceResolver<? extends LuceneCollectorExpression<?>> referenceResolver;
    private final InputFactory inputFactory;

    public DocInputFactory(NodeContext nodeCtx, ReferenceResolver<? extends LuceneCollectorExpression<?>> referenceResolver) {
        this.inputFactory = new InputFactory(nodeCtx);
        this.referenceResolver = referenceResolver;
    }

    public InputFactory.Context<? extends LuceneCollectorExpression<?>> extractImplementations(TransactionContext txnCtx, RoutedCollectPhase phase) {
        OrderBy orderBy = phase.orderBy();
        ReferenceResolver<LuceneCollectorExpression<Object>> refResolver = orderBy == null ? this.referenceResolver : ref -> {
            if (orderBy.orderBySymbols().contains(ref)) {
                DataType<?> dataType = ref.valueType();
                return new OrderByCollectorExpression(ref, orderBy, dataType::sanitizeValue);
            }
            return this.referenceResolver.getImplementation(ref);
        };
        InputFactory.Context<LuceneCollectorExpression<?>> ctx = this.inputFactory.ctxForRefs(txnCtx, refResolver);
        ctx.add(phase.toCollect());
        return ctx;
    }

    public InputFactory.Context<? extends LuceneCollectorExpression<?>> getCtx(TransactionContext txnCtx) {
        return this.inputFactory.ctxForRefs(txnCtx, this.referenceResolver);
    }
}

