/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.analyze.WhereClause;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.engine.pipeline.ProjectionToProjectorVisitor;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.Projectors;
import io.crate.execution.jobs.NodeLimits;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.shard.ShardReferenceResolver;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public abstract class ShardCollectorProvider {
    private final ProjectorFactory projectorFactory;
    private final ShardRowContext shardRowContext;
    protected final IndexShard indexShard;
    final EvaluatingNormalizer shardNormalizer;
    private final BatchIteratorFactory batchIteratorFactory;

    ShardCollectorProvider(ClusterService clusterService, CircuitBreakerService circuitBreakerService, NodeLimits nodeJobsCounter, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, ElasticsearchClient elasticsearchClient, IndexShard indexShard, ShardRowContext shardRowContext, Map<String, FileOutputFactory> fileOutputFactoryMap) {
        this.indexShard = indexShard;
        this.shardRowContext = shardRowContext;
        this.shardNormalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.SHARD, new ShardReferenceResolver(nodeCtx.schemas(), shardRowContext), null);
        this.projectorFactory = new ProjectionToProjectorVisitor(clusterService, nodeJobsCounter, circuitBreakerService, nodeCtx, threadPool, settings, elasticsearchClient, new InputFactory(nodeCtx), this.shardNormalizer, t -> null, t -> null, indexShard.indexSettings().getIndexVersionCreated(), indexShard.shardId(), fileOutputFactoryMap);
        this.batchIteratorFactory = new BatchIteratorFactory();
    }

    public ShardRowContext shardRowContext() {
        return this.shardRowContext;
    }

    public CompletableFuture<BatchIteratorFactory> awaitShardSearchActive() {
        return this.indexShard.awaitShardSearchActive().thenApply(ignored -> this.batchIteratorFactory);
    }

    @Nullable
    protected abstract BatchIterator<Row> getProjectionFusedIterator(RoutedCollectPhase var1, CollectTask var2);

    protected abstract BatchIterator<Row> getUnorderedIterator(RoutedCollectPhase var1, boolean var2, CollectTask var3);

    protected abstract OrderedDocCollector getOrderedCollector(RoutedCollectPhase var1, SharedShardContext var2, CollectTask var3, boolean var4);

    public ProjectorFactory getProjectorFactory() {
        return this.projectorFactory;
    }

    public class BatchIteratorFactory {
        public BatchIterator<Row> getIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) {
            BatchIterator<Row> fusedIterator;
            boolean isOpenIndex;
            assert (collectPhase.orderBy() == null) : "getDocCollector shouldn't be called if there is an orderBy on the collectPhase";
            assert (collectPhase.maxRowGranularity() == RowGranularity.DOC) : "granularity must be DOC";
            boolean bl = isOpenIndex = !ShardCollectorProvider.this.indexShard.isClosed();
            if (isOpenIndex && (fusedIterator = ShardCollectorProvider.this.getProjectionFusedIterator(collectPhase, collectTask)) != null) {
                return fusedIterator;
            }
            BatchIterator<Row> iterator = isOpenIndex && WhereClause.canMatch(collectPhase.where()) ? ShardCollectorProvider.this.getUnorderedIterator(collectPhase, requiresScroll, collectTask) : InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL);
            return Projectors.wrap(Projections.shardProjections(collectPhase.projections()), collectPhase.jobId(), collectTask.txnCtx(), collectTask.getRamAccounting(), collectTask.memoryManager(), ShardCollectorProvider.this.projectorFactory, iterator);
        }

        public OrderedDocCollector getOrderedCollector(RoutedCollectPhase collectPhase, SharedShardContext sharedShardContext, CollectTask collectTask, boolean requiresRepeat) {
            return ShardCollectorProvider.this.getOrderedCollector(collectPhase, sharedShardContext, collectTask, requiresRepeat);
        }
    }
}

