/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.collectors.DummyScorer;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.InputRow;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.OrderByCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.jetbrains.annotations.Nullable;

class ScoreDocRowFunction
implements Function<ScoreDoc, Row> {
    private final List<OrderByCollectorExpression> orderByCollectorExpressions = new ArrayList<OrderByCollectorExpression>();
    private final IndexReader indexReader;
    private final LuceneCollectorExpression<?>[] expressions;
    private final DummyScorer scorer;
    private final InputRow inputRow;
    private final Runnable onScoreDoc;
    private final ReaderContext[] readerContexts;

    ScoreDocRowFunction(IndexReader indexReader, List<? extends Input<?>> inputs, Collection<? extends LuceneCollectorExpression<?>> expressions, DummyScorer scorer, Runnable onScoreDoc) {
        this.indexReader = indexReader;
        this.expressions = expressions.toArray(new LuceneCollectorExpression[0]);
        this.scorer = scorer;
        this.inputRow = new InputRow(inputs);
        this.onScoreDoc = onScoreDoc;
        for (LuceneCollectorExpression<?> expression : this.expressions) {
            if (!(expression instanceof OrderByCollectorExpression)) continue;
            OrderByCollectorExpression orderByExpr = (OrderByCollectorExpression)expression;
            this.orderByCollectorExpressions.add(orderByExpr);
        }
        List leaves = indexReader.leaves();
        this.readerContexts = new ReaderContext[leaves.size()];
        try {
            for (int i = 0; i < this.readerContexts.length; ++i) {
                this.readerContexts[i] = new ReaderContext((LeafReaderContext)leaves.get(i));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @Nullable
    public Row apply(@Nullable ScoreDoc input) {
        this.onScoreDoc.run();
        if (input == null) {
            return null;
        }
        FieldDoc fieldDoc = (FieldDoc)input;
        this.scorer.score(fieldDoc.score);
        for (int i = 0; i < this.orderByCollectorExpressions.size(); ++i) {
            this.orderByCollectorExpressions.get(i).setNextFieldDoc(fieldDoc);
        }
        List leaves = this.indexReader.leaves();
        int readerIndex = ReaderUtil.subIndex((int)fieldDoc.doc, (List)leaves);
        LeafReaderContext subReaderContext = (LeafReaderContext)leaves.get(readerIndex);
        ReaderContext readerContext = this.readerContexts[readerIndex];
        int subDoc = fieldDoc.doc - subReaderContext.docBase;
        try {
            for (LuceneCollectorExpression<?> expression : this.expressions) {
                expression.setNextReader(readerContext);
                expression.setNextDocId(subDoc);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.inputRow;
    }
}

