/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.execution.engine.collect.files.FileInputFactory;
import io.crate.execution.engine.collect.files.LocalFsFileInputFactory;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.engine.export.LocalFsFileOutputFactory;
import io.crate.plugin.CopyPlugin;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;

public class CopyModule
extends AbstractModule {
    List<CopyPlugin> copyPlugins;

    public CopyModule(List<CopyPlugin> copyPlugins) {
        this.copyPlugins = copyPlugins;
    }

    protected void configure() {
        MapBinder fileInputFactoryMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, FileInputFactory.class);
        MapBinder fileOutputFactoryMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, FileOutputFactory.class);
        fileInputFactoryMapBinder.addBinding((Object)"file").to(LocalFsFileInputFactory.class).asEagerSingleton();
        fileOutputFactoryMapBinder.addBinding((Object)"file").to(LocalFsFileOutputFactory.class).asEagerSingleton();
        for (CopyPlugin copyPlugin : this.copyPlugins) {
            for (Map.Entry<String, FileInputFactory> entry : copyPlugin.getFileInputFactories().entrySet()) {
                fileInputFactoryMapBinder.addBinding((Object)entry.getKey()).toInstance((Object)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : copyPlugin.getFileOutputFactories().entrySet()) {
                fileOutputFactoryMapBinder.addBinding((Object)entry.getKey()).toInstance((Object)((FileOutputFactory)entry.getValue()));
            }
        }
    }
}

