/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import com.carrotsearch.hppc.IntIndexedContainer;
import io.crate.common.collections.Iterables;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Row;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.RowsTransformer;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.sys.SysRowUpdater;
import io.crate.expression.reference.sys.check.node.SysNodeChecks;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.information.InformationSchemaTableDefinitions;
import io.crate.metadata.pgcatalog.PgCatalogTableDefinitions;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import io.crate.metadata.sys.SysTableDefinitions;
import io.crate.role.Role;
import io.crate.role.Roles;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;

public class SystemCollectSource
implements CollectSource {
    private final Map<RelationName, SysRowUpdater<?>> rowUpdaters;
    private final ClusterService clusterService;
    private final InputFactory inputFactory;
    private final Roles roles;
    private final InformationSchemaTableDefinitions informationSchemaTables;
    private final SysTableDefinitions sysTables;
    private final PgCatalogTableDefinitions pgCatalogTables;

    @Inject
    public SystemCollectSource(ClusterService clusterService, NodeContext nodeCtx, Roles roles, InformationSchemaTableDefinitions informationSchemaTables, SysTableDefinitions sysTableDefinitions, SysNodeChecks sysNodeChecks, PgCatalogTableDefinitions pgCatalogTables) {
        this.clusterService = clusterService;
        this.inputFactory = new InputFactory(nodeCtx);
        this.roles = roles;
        this.informationSchemaTables = informationSchemaTables;
        this.sysTables = sysTableDefinitions;
        this.pgCatalogTables = pgCatalogTables;
        this.rowUpdaters = Map.of(SysNodeChecksTableInfo.IDENT, sysNodeChecks);
    }

    Function<Iterable<?>, Iterable<? extends Row>> toRowsIterableTransformation(RoutedCollectPhase collectPhase, TransactionContext txnCtx, ReferenceResolver<?> referenceResolver, boolean requiresRepeat) {
        return objects -> this.recordsToRows(collectPhase, txnCtx, referenceResolver, requiresRepeat, (Iterable<?>)objects);
    }

    private Iterable<? extends Row> recordsToRows(RoutedCollectPhase collectPhase, TransactionContext txnCtx, ReferenceResolver<?> referenceResolver, boolean requiresRepeat, Iterable<?> data) {
        if (requiresRepeat) {
            ArrayList copy = new ArrayList();
            for (Object record : data) {
                copy.add(record);
            }
            data = copy;
        }
        return RowsTransformer.toRowsIterable(txnCtx, this.inputFactory, referenceResolver, collectPhase, data);
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase phase, CollectTask collectTask, boolean supportMoveToStart) {
        RoutedCollectPhase collectPhase = (RoutedCollectPhase)phase;
        Map<String, Map<String, IntIndexedContainer>> locations = collectPhase.routing().locations();
        String table = (String)Iterables.getOnlyElement(locations.get(this.clusterService.localNode().getId()).keySet());
        RelationName relationName = RelationName.fromIndexName(table);
        StaticTableDefinition<?> tableDefinition = this.tableDefinition(relationName);
        Role user = Objects.requireNonNull(this.roles.findUser(txnCtx.sessionSettings().userName()), "User who invoked a statement must exist");
        return CompletableFuture.completedFuture(CollectingBatchIterator.newInstance(() -> {}, t -> {}, () -> tableDefinition.retrieveRecords(txnCtx, user).thenApply(records -> this.recordsToRows(collectPhase, collectTask.txnCtx(), tableDefinition.getReferenceResolver(), supportMoveToStart, (Iterable<?>)records)), (boolean)tableDefinition.involvesIO()));
    }

    public StaticTableDefinition<?> tableDefinition(RelationName relationName) {
        StaticTableDefinition<?> tableDefinition = switch (relationName.schema()) {
            case "information_schema" -> this.informationSchemaTables.get(relationName);
            case "sys" -> this.sysTables.get(relationName);
            case "pg_catalog" -> this.pgCatalogTables.get(relationName);
            default -> throw new SchemaUnknownException(relationName.schema());
        };
        if (tableDefinition == null) {
            throw new RelationUnknown(relationName);
        }
        return tableDefinition;
    }

    public SysRowUpdater<?> getRowUpdater(RelationName ident) {
        assert (this.rowUpdaters.containsKey(ident)) : "RowUpdater for " + ident.fqn() + " must exist";
        return this.rowUpdaters.get(ident);
    }
}

