/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.Streamer;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.distribution.MultiBucketBuilder;
import io.crate.execution.engine.distribution.StreamBucket;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModuloBucketBuilder
implements MultiBucketBuilder {
    private final int numBuckets;
    private final List<StreamBucket.Builder> bucketBuilders;
    private final int distributedByColumnIdx;
    private int size = 0;

    public ModuloBucketBuilder(Streamer<?>[] streamers, int numBuckets, int distributedByColumnIdx, RamAccounting ramAccounting) {
        this.numBuckets = numBuckets;
        this.distributedByColumnIdx = distributedByColumnIdx;
        this.bucketBuilders = new ArrayList<StreamBucket.Builder>(numBuckets);
        for (int i = 0; i < numBuckets; ++i) {
            this.bucketBuilders.add(new StreamBucket.Builder(streamers, ramAccounting));
        }
    }

    @Override
    public void add(Row row) {
        StreamBucket.Builder builder = this.bucketBuilders.get(this.getBucket(row));
        builder.add(row);
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void build(StreamBucket[] buckets) {
        assert (buckets.length == this.numBuckets) : "length of the provided array must match numBuckets";
        for (int i = 0; i < this.numBuckets; ++i) {
            StreamBucket.Builder builder = this.bucketBuilders.get(i);
            buckets[i] = builder.build();
            builder.reset();
        }
        this.size = 0;
    }

    private int getBucket(Row row) {
        int hash = ModuloBucketBuilder.hashCode(row.get(this.distributedByColumnIdx));
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        return Math.abs(hash) % this.numBuckets;
    }

    private static int hashCode(@Nullable Object value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public long ramBytesUsed() {
        long sum = 0L;
        for (int i = 0; i < this.bucketBuilders.size(); ++i) {
            sum += this.bucketBuilders.get(i).ramBytesUsed();
        }
        return sum;
    }
}

