/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import io.crate.common.concurrent.KillableCompletionStage;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class BatchPagingIterator<Key>
implements BatchIterator<Row> {
    private final PagingIterator<Key, Row> pagingIterator;
    private final Function<Key, KillableCompletionStage<? extends Iterable<? extends KeyIterable<Key, Row>>>> fetchMore;
    private final BooleanSupplier isUpstreamExhausted;
    private final Consumer<? super Throwable> closeCallback;
    private Throwable killed;
    private KillableCompletionStage<? extends Iterable<? extends KeyIterable<Key, Row>>> currentlyLoading;
    private Iterator<Row> it;
    private boolean closed = false;
    private Row current;

    public BatchPagingIterator(PagingIterator<Key, Row> pagingIterator, Function<Key, KillableCompletionStage<? extends Iterable<? extends KeyIterable<Key, Row>>>> fetchMore, BooleanSupplier isUpstreamExhausted, Consumer<? super Throwable> closeCallback) {
        this.pagingIterator = pagingIterator;
        this.it = pagingIterator;
        this.fetchMore = fetchMore;
        this.isUpstreamExhausted = isUpstreamExhausted;
        this.closeCallback = closeCallback;
    }

    public Row currentElement() {
        return this.current;
    }

    public void moveToStart() {
        this.raiseIfClosedOrKilled();
        this.it = this.pagingIterator.repeat().iterator();
        this.current = null;
    }

    public boolean moveNext() {
        this.raiseIfClosedOrKilled();
        if (this.it.hasNext()) {
            this.current = this.it.next();
            return true;
        }
        this.current = null;
        return false;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.pagingIterator.finish();
            this.closeCallback.accept(this.killed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<?> loadNextBatch() throws Exception {
        KillableCompletionStage<? extends Iterable<? extends KeyIterable<Key, Row>>> future;
        Throwable err;
        if (this.closed) {
            throw new IllegalStateException("BatchIterator already closed");
        }
        if (this.allLoaded()) {
            throw new IllegalStateException("All data already loaded");
        }
        BatchPagingIterator batchPagingIterator = this;
        synchronized (batchPagingIterator) {
            err = this.killed;
            if (err == null) {
                future = this.fetchMore.apply(this.pagingIterator.exhaustedIterable());
                this.currentlyLoading = future;
            } else {
                future = KillableCompletionStage.failed((Throwable)err);
            }
        }
        if (err == null) {
            return future.whenComplete(this::onNextPage);
        }
        return future;
    }

    private void onNextPage(Iterable<? extends KeyIterable<Key, Row>> rows, Throwable ex) {
        if (ex == null) {
            this.pagingIterator.merge(rows);
            if (this.isUpstreamExhausted.getAsBoolean()) {
                this.pagingIterator.finish();
            }
        } else {
            this.killed = ex;
            throw Exceptions.toRuntimeException((Throwable)ex);
        }
    }

    public boolean allLoaded() {
        return this.isUpstreamExhausted.getAsBoolean();
    }

    public boolean hasLazyResultSet() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseIfClosedOrKilled() {
        Throwable err;
        BatchPagingIterator batchPagingIterator = this;
        synchronized (batchPagingIterator) {
            err = this.killed;
        }
        if (err != null) {
            Exceptions.rethrowUnchecked((Throwable)err);
        }
        if (this.closed) {
            throw new IllegalStateException("Iterator is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(@NotNull Throwable throwable) {
        KillableCompletionStage<? extends Iterable<? extends KeyIterable<Key, Row>>> loading;
        BatchPagingIterator batchPagingIterator = this;
        synchronized (batchPagingIterator) {
            this.killed = throwable;
            loading = this.currentlyLoading;
        }
        this.close();
        if (loading != null) {
            loading.kill(throwable);
        }
    }
}

