/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.auth.AccessControl;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.SourceIndexWriterReturnSummaryProjection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.UpsertResultCollector;
import io.crate.execution.engine.indexing.UpsertResultCollectors;
import io.crate.expression.InputFactory;
import io.crate.metadata.TransactionContext;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.jetbrains.annotations.Nullable;

public class UpsertResultContext {
    private final Input<String> sourceUriInput;
    private final Input<String> sourceUriFailureInput;
    private final Input<Long> lineNumberInput;
    private final Input<String> sourceParsingFailureInput;
    private final List<? extends CollectExpression<Row, ?>> sourceInfoExpressions;
    private final UpsertResultCollector resultCollector;

    public static UpsertResultContext forRowCount() {
        return new UpsertResultContext(() -> null, () -> null, () -> null, () -> null, Collections.emptyList(), UpsertResultCollectors.newRowCountCollector()){

            @Override
            BiConsumer<ShardedRequests, String> getItemFailureRecorder() {
                return (s, f) -> {};
            }

            @Override
            Predicate<ShardedRequests> getHasSourceFailureChecker() {
                return ignored -> false;
            }
        };
    }

    public static UpsertResultContext forResultRows() {
        return new UpsertResultContext(() -> null, () -> null, () -> null, () -> null, Collections.emptyList(), UpsertResultCollectors.newResultRowCollector()){

            @Override
            BiConsumer<ShardedRequests, String> getItemFailureRecorder() {
                return (s, f) -> {};
            }

            @Override
            Predicate<ShardedRequests> getHasSourceFailureChecker() {
                return ignored -> false;
            }
        };
    }

    public static UpsertResultContext forReturnSummary(TransactionContext txnCtx, SourceIndexWriterReturnSummaryProjection projection, DiscoveryNode discoveryNode, AccessControl accessControl, InputFactory inputFactory) {
        InputFactory.Context<CollectExpression<Row, ?>> ctxSourceInfo = inputFactory.ctxForInputColumns(txnCtx);
        Input<?> sourceUriInput = ctxSourceInfo.add(projection.sourceUri());
        Input<?> sourceUriFailureInput = ctxSourceInfo.add(projection.sourceUriFailure());
        Input<?> lineNumberInput = ctxSourceInfo.add(projection.lineNumber());
        Input<?> sourceParsingFailureInput = projection.sourceParsingFailure() == null ? null : ctxSourceInfo.add(projection.sourceParsingFailure());
        return new UpsertResultContext(sourceUriInput, sourceUriFailureInput, lineNumberInput, sourceParsingFailureInput, ctxSourceInfo.expressions(), UpsertResultCollectors.newSummaryCollector(discoveryNode, accessControl));
    }

    private UpsertResultContext(Input<String> sourceUriInput, Input<String> sourceUriFailureInput, Input<Long> lineNumberInput, @Nullable Input<String> sourceParsingFailureInput, List<? extends CollectExpression<Row, ?>> sourceInfoExpressions, UpsertResultCollector resultCollector) {
        this.sourceUriInput = sourceUriInput;
        this.sourceUriFailureInput = sourceUriFailureInput;
        this.lineNumberInput = lineNumberInput;
        this.sourceParsingFailureInput = sourceParsingFailureInput;
        this.sourceInfoExpressions = sourceInfoExpressions;
        this.resultCollector = resultCollector;
    }

    Input<String> getSourceUriInput() {
        return this.sourceUriInput;
    }

    Input<Long> getLineNumberInput() {
        return this.lineNumberInput;
    }

    List<? extends CollectExpression<Row, ?>> getSourceInfoExpressions() {
        return this.sourceInfoExpressions;
    }

    UpsertResultCollector getResultCollector() {
        return this.resultCollector;
    }

    BiConsumer<ShardedRequests, String> getItemFailureRecorder() {
        return (s, f) -> s.addFailedItem((String)this.sourceUriInput.value(), (String)f, (Long)this.lineNumberInput.value());
    }

    Predicate<ShardedRequests> getHasSourceFailureChecker() {
        return s -> {
            String sourceUriFailure;
            String sourceParsingFailure;
            String uriInputValue = (String)this.sourceUriInput.value();
            boolean lineHasFailure = false;
            String string = sourceParsingFailure = this.sourceParsingFailureInput == null ? null : (String)this.sourceParsingFailureInput.value();
            if (sourceParsingFailure != null) {
                lineHasFailure = true;
                s.addFailedItem(uriInputValue, sourceParsingFailure, (Long)this.lineNumberInput.value());
            }
            if ((sourceUriFailure = (String)this.sourceUriFailureInput.value()) != null) {
                s.addFailedUri(uriInputValue, sourceUriFailure);
                lineHasFailure = true;
            }
            return lineHasFailure;
        };
    }
}

