/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import java.util.function.LongToIntFunction;
import org.elasticsearch.common.breaker.CircuitBreaker;

public class RamBlockSizeCalculator
implements LongToIntFunction {
    public static final int FALLBACK_SIZE = 500;
    private final int defaultBlockSize;
    private final CircuitBreaker circuitBreaker;
    private final long estimatedRowSizeForLeft;

    public RamBlockSizeCalculator(int defaultBlockSize, CircuitBreaker circuitBreaker, long estimatedRowSizeForLeft) {
        this.defaultBlockSize = defaultBlockSize;
        this.circuitBreaker = circuitBreaker;
        this.estimatedRowSizeForLeft = estimatedRowSizeForLeft;
    }

    @Override
    public int applyAsInt(long averageSizeInBytes) {
        long leftRowSize;
        long l = leftRowSize = averageSizeInBytes > 0L ? averageSizeInBytes : this.estimatedRowSizeForLeft;
        if (leftRowSize <= 0L) {
            return 500;
        }
        if (this.circuitBreaker.getLimit() == -1L) {
            return 500;
        }
        long availableMemory = this.circuitBreaker.getLimit() - this.circuitBreaker.getUsed();
        long numRowsFittingIntoAvailableMemory = availableMemory / leftRowSize;
        int blockSize = (int)Math.min((long)this.defaultBlockSize, numRowsFittingIntoAvailableMemory);
        return blockSize <= 0 ? 10 : blockSize;
    }
}

