/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.analyze.SymbolEvaluator;
import io.crate.breaker.TypedCellsAccounting;
import io.crate.common.collections.Iterables;
import io.crate.common.collections.Lists;
import io.crate.common.unit.TimeValue;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.SysUpdateProjector;
import io.crate.execution.dml.SysUpdateResultSetProjector;
import io.crate.execution.dml.delete.ShardDeleteAction;
import io.crate.execution.dml.delete.ShardDeleteRequest;
import io.crate.execution.dml.upsert.ShardUpsertAction;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.dsl.projection.AggregationProjection;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.CorrelatedJoinProjection;
import io.crate.execution.dsl.projection.DeleteProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.FetchProjection;
import io.crate.execution.dsl.projection.FilterProjection;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.LimitAndOffsetProjection;
import io.crate.execution.dsl.projection.LimitDistinctProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.OrderedLimitAndOffsetProjection;
import io.crate.execution.dsl.projection.ProjectSetProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.execution.dsl.projection.SourceIndexWriterProjection;
import io.crate.execution.dsl.projection.SourceIndexWriterReturnSummaryProjection;
import io.crate.execution.dsl.projection.SysUpdateProjection;
import io.crate.execution.dsl.projection.UpdateProjection;
import io.crate.execution.dsl.projection.WindowAggProjection;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.engine.CorrelatedJoinProjector;
import io.crate.execution.engine.aggregation.AggregationContext;
import io.crate.execution.engine.aggregation.AggregationPipe;
import io.crate.execution.engine.aggregation.GroupingProjector;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.engine.export.FileWriterProjector;
import io.crate.execution.engine.fetch.FetchNodeAction;
import io.crate.execution.engine.fetch.FetchProjector;
import io.crate.execution.engine.fetch.TransportFetchOperation;
import io.crate.execution.engine.indexing.ColumnIndexWriterProjector;
import io.crate.execution.engine.indexing.DMLProjector;
import io.crate.execution.engine.indexing.IndexWriterProjector;
import io.crate.execution.engine.indexing.ShardDMLExecutor;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.engine.pipeline.FilterProjector;
import io.crate.execution.engine.pipeline.FlatMapProjector;
import io.crate.execution.engine.pipeline.InputRowProjector;
import io.crate.execution.engine.pipeline.LimitAndOffsetProjector;
import io.crate.execution.engine.pipeline.MergeCountProjector;
import io.crate.execution.engine.pipeline.OffsetProjector;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.TableFunctionApplier;
import io.crate.execution.engine.pipeline.TopNDistinctProjector;
import io.crate.execution.engine.sort.OrderingByPosition;
import io.crate.execution.engine.sort.SortingLimitAndOffsetProjector;
import io.crate.execution.engine.sort.SortingProjector;
import io.crate.execution.engine.window.WindowProjector;
import io.crate.execution.jobs.NodeLimits;
import io.crate.execution.support.ThreadPools;
import io.crate.expression.InputFactory;
import io.crate.expression.RowFilter;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.expression.reference.sys.SysRowUpdater;
import io.crate.expression.reference.sys.check.node.SysNodeCheck;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.memory.MemoryManager;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.NumberOfReplicas;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import io.crate.planner.operators.InsertFromValues;
import io.crate.planner.operators.SubQueryResults;
import io.crate.role.Role;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.elasticsearch.Version;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public class ProjectionToProjectorVisitor
extends ProjectionVisitor<Context, Projector>
implements ProjectorFactory {
    private static final int UNBOUNDED_COLLECTOR_THRESHOLD = 10000;
    private final ClusterService clusterService;
    private final NodeLimits nodeJobsCounter;
    private final NodeContext nodeCtx;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final ElasticsearchClient elasticsearchClient;
    private final InputFactory inputFactory;
    private final EvaluatingNormalizer normalizer;
    private final Function<RelationName, SysRowUpdater<?>> sysUpdaterGetter;
    private final Function<RelationName, StaticTableDefinition<?>> staticTableDefinitionGetter;
    private final CircuitBreakerService circuitBreakerService;
    private final Version indexVersionCreated;
    @Nullable
    private final ShardId shardId;
    private final int numProcessors;
    private final Map<String, FileOutputFactory> fileOutputFactoryMap;

    public ProjectionToProjectorVisitor(ClusterService clusterService, NodeLimits nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, ElasticsearchClient elasticsearchClient, InputFactory inputFactory, EvaluatingNormalizer normalizer, Function<RelationName, SysRowUpdater<?>> sysUpdaterGetter, Function<RelationName, StaticTableDefinition<?>> staticTableDefinitionGetter, Version indexVersionCreated, @Nullable ShardId shardId, Map<String, FileOutputFactory> fileOutputFactoryMap) {
        this.clusterService = clusterService;
        this.nodeJobsCounter = nodeJobsCounter;
        this.circuitBreakerService = circuitBreakerService;
        this.nodeCtx = nodeCtx;
        this.threadPool = threadPool;
        this.settings = settings;
        this.elasticsearchClient = elasticsearchClient;
        this.inputFactory = inputFactory;
        this.normalizer = normalizer;
        this.sysUpdaterGetter = sysUpdaterGetter;
        this.staticTableDefinitionGetter = staticTableDefinitionGetter;
        this.indexVersionCreated = indexVersionCreated;
        this.shardId = shardId;
        this.numProcessors = EsExecutors.numberOfProcessors(settings);
        this.fileOutputFactoryMap = fileOutputFactoryMap;
    }

    public ProjectionToProjectorVisitor(ClusterService clusterService, NodeLimits nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, ElasticsearchClient elasticsearchClient, InputFactory inputFactory, EvaluatingNormalizer normalizer, Function<RelationName, SysRowUpdater<?>> sysUpdaterGetter, Function<RelationName, StaticTableDefinition<?>> staticTableDefinitionGetter) {
        this(clusterService, nodeJobsCounter, circuitBreakerService, nodeCtx, threadPool, settings, elasticsearchClient, inputFactory, normalizer, sysUpdaterGetter, staticTableDefinitionGetter, Version.CURRENT, null, null);
    }

    @Override
    public RowGranularity supportedGranularity() {
        if (this.shardId == null) {
            return RowGranularity.NODE;
        }
        return RowGranularity.SHARD;
    }

    @Override
    public Projector visitOrderedLimitAndOffset(OrderedLimitAndOffsetProjection projection, Context context) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(context.txnCtx);
        ctx.add(projection.outputs());
        ctx.add(projection.orderBy());
        int numOutputs = projection.outputs().size();
        List<DataType<?>> rowTypes = Symbols.typeView(Lists.concat(projection.outputs(), projection.orderBy()));
        List<Input<?>> inputs = ctx.topLevelInputs();
        int[] orderByIndices = new int[inputs.size() - numOutputs];
        int idx = 0;
        int i = numOutputs;
        while (i < inputs.size()) {
            orderByIndices[idx++] = i++;
        }
        int rowMemoryOverhead = 32;
        TypedCellsAccounting rowAccounting = new TypedCellsAccounting(rowTypes, context.ramAccounting, rowMemoryOverhead);
        if (projection.limit() > -1) {
            return new SortingLimitAndOffsetProjector(rowAccounting, inputs, ctx.expressions(), numOutputs, OrderingByPosition.arrayOrdering(rowTypes, orderByIndices, projection.reverseFlags(), projection.nullsFirst()), projection.limit(), projection.offset(), 10000);
        }
        return new SortingProjector(rowAccounting, inputs, ctx.expressions(), numOutputs, OrderingByPosition.arrayOrdering(rowTypes, orderByIndices, projection.reverseFlags(), projection.nullsFirst()), projection.offset());
    }

    @Override
    public Projector visitLimitDistinct(LimitDistinctProjection limitDistinct, Context context) {
        TypedCellsAccounting rowAccounting = new TypedCellsAccounting(Symbols.typeView(limitDistinct.outputs()), context.ramAccounting, 0);
        return new TopNDistinctProjector(limitDistinct.limit(), rowAccounting);
    }

    @Override
    public Projector visitLimitAndOffsetProjection(LimitAndOffsetProjection projection, Context context) {
        if (projection.limit() != -1) {
            return new LimitAndOffsetProjector(projection.limit(), projection.offset());
        }
        if (projection.offset() != 0) {
            return new OffsetProjector(projection.offset());
        }
        throw new IllegalArgumentException("LimitAndOffsetProjection should have at least one of the limit and offset set");
    }

    @Override
    public Projector visitEvalProjection(EvalProjection projection, Context context) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(context.txnCtx, projection.outputs());
        return new InputRowProjector(ctx.topLevelInputs(), ctx.expressions());
    }

    @Override
    public Projector visitGroupProjection(GroupProjection projection, Context context) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForAggregations(context.txnCtx);
        ctx.add(projection.keys());
        ctx.add(projection.values());
        List<Input<?>> keyInputs = ctx.topLevelInputs();
        return new GroupingProjector(projection.keys(), keyInputs, (CollectExpression[])ctx.expressions().toArray(CollectExpression[]::new), projection.mode(), ctx.aggregations().toArray(new AggregationContext[0]), context.ramAccounting, context.memoryManager, this.clusterService.state().nodes().getMinNodeVersion(), this.indexVersionCreated);
    }

    @Override
    public Projector visitMergeCountProjection(MergeCountProjection projection, Context context) {
        return new MergeCountProjector();
    }

    @Override
    public Projector visitAggregationProjection(AggregationProjection projection, Context context) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForAggregations(context.txnCtx);
        ctx.add(projection.aggregations());
        return new AggregationPipe(ctx.expressions(), projection.mode(), ctx.aggregations().toArray(new AggregationContext[0]), context.ramAccounting, context.memoryManager, this.clusterService.state().nodes().getMinNodeVersion(), this.indexVersionCreated);
    }

    @Override
    public Projector visitWriterProjection(WriterProjection projection, Context context) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(context.txnCtx);
        List<Input<?>> inputs = null;
        if (!projection.inputs().isEmpty()) {
            ctx.add(projection.inputs());
            inputs = ctx.topLevelInputs();
        }
        projection = projection.normalize(this.normalizer, context.txnCtx);
        String uri = DataTypes.STRING.sanitizeValue(SymbolEvaluator.evaluate(context.txnCtx, this.nodeCtx, projection.uri(), Row.EMPTY, SubQueryResults.EMPTY));
        assert (uri != null) : "URI must not be null";
        assert (this.shardId != null) : "ShardId must be set to use WriterProjection";
        IndexParts indexParts = IndexName.decode(this.shardId.getIndexName());
        String fileName = String.format(Locale.ENGLISH, "%s_%s_%s.json", indexParts.table(), this.shardId.id(), indexParts.partitionIdent());
        StringBuilder sb = new StringBuilder(uri);
        if (!uri.endsWith("/")) {
            sb.append("/");
        }
        sb.append(fileName);
        if (projection.compressionType() == WriterProjection.CompressionType.GZIP) {
            sb.append(".gz");
        }
        uri = sb.toString();
        return new FileWriterProjector(this.threadPool.generic(), uri, projection.compressionType(), inputs, ctx.expressions(), projection.outputNames(), projection.outputFormat(), this.fileOutputFactoryMap, projection.withClauseOptions());
    }

    @Override
    public Projector visitSourceIndexWriterProjection(SourceIndexWriterProjection projection, Context context) {
        UpsertResultContext upsertResultContext;
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(context.txnCtx);
        ArrayList partitionedByInputs = new ArrayList(projection.partitionedBySymbols().size());
        for (Symbol partitionedBySymbol : projection.partitionedBySymbols()) {
            partitionedByInputs.add(ctx.add(partitionedBySymbol));
        }
        Input<?> sourceInput = ctx.add(projection.rawSource());
        Supplier<String> indexNameResolver = IndexName.createResolver(projection.tableIdent(), projection.partitionIdent(), partitionedByInputs);
        ClusterState state = this.clusterService.state();
        DocTableInfo tableInfo = (DocTableInfo)this.nodeCtx.schemas().getTableInfo(projection.tableIdent());
        int targetTableNumShards = tableInfo.numberOfShards();
        int targetTableNumReplicas = NumberOfReplicas.effectiveNumReplicas(tableInfo.parameters(), state.nodes());
        if (projection instanceof SourceIndexWriterReturnSummaryProjection) {
            Role sessionUser = this.nodeCtx.roles().getUser(context.txnCtx.sessionSettings().userName());
            upsertResultContext = UpsertResultContext.forReturnSummary(context.txnCtx, (SourceIndexWriterReturnSummaryProjection)projection, this.clusterService.localNode(), this.nodeCtx.roles().getAccessControl(sessionUser, sessionUser), this.inputFactory);
        } else {
            upsertResultContext = UpsertResultContext.forRowCount();
        }
        return new IndexWriterProjector(this.clusterService, this.nodeJobsCounter, this.circuitBreakerService.getBreaker("query"), context.ramAccounting, this.threadPool.scheduler(), this.threadPool.executor("search"), context.txnCtx, this.nodeCtx, state.metadata().settings(), targetTableNumShards, targetTableNumReplicas, this.elasticsearchClient, indexNameResolver, projection.rawSourceReference(), projection.primaryKeys(), projection.ids(), projection.clusteredBy(), projection.clusteredByIdent(), sourceInput, ctx.expressions(), projection.bulkActions(), projection.excludes(), projection.autoCreateIndices(), projection.overwriteDuplicates(), context.jobId, upsertResultContext, projection.failFast());
    }

    @Override
    public Projector visitColumnIndexWriterProjection(ColumnIndexWriterProjection projection, Context context) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(context.txnCtx);
        ArrayList partitionedByInputs = new ArrayList(projection.partitionedBySymbols().size());
        for (Symbol partitionedBySymbol : projection.partitionedBySymbols()) {
            partitionedByInputs.add(ctx.add(partitionedBySymbol));
        }
        ArrayList insertInputs = new ArrayList(projection.allTargetColumns().size());
        List<Symbol> columnSymbols = InputColumns.create(projection.allTargetColumns(), new InputColumns.SourceSymbols(projection.allTargetColumns()));
        for (Symbol symbol : columnSymbols) {
            insertInputs.add(ctx.add(symbol));
        }
        ClusterState state = this.clusterService.state();
        DocTableInfo tableInfo = (DocTableInfo)this.nodeCtx.schemas().getTableInfo(projection.tableIdent());
        int targetTableNumShards = tableInfo.numberOfShards();
        int targetTableNumReplicas = NumberOfReplicas.effectiveNumReplicas(tableInfo.parameters(), state.nodes());
        HashMap validatorsCache = new HashMap();
        BiConsumer<String, IndexItem> constraintsChecker = (indexName, indexItem) -> InsertFromValues.checkConstraints(indexItem, indexName, (DocTableInfo)this.nodeCtx.schemas().getTableInfo(projection.tableIdent()), context.txnCtx, this.nodeCtx, validatorsCache, projection.allTargetColumns());
        return new ColumnIndexWriterProjector(this.clusterService, constraintsChecker, this.nodeJobsCounter, this.circuitBreakerService.getBreaker("query"), context.ramAccounting, this.threadPool.scheduler(), this.threadPool.executor("search"), context.txnCtx, this.nodeCtx, state.metadata().settings(), targetTableNumShards, targetTableNumReplicas, IndexName.createResolver(projection.tableIdent(), projection.partitionIdent(), partitionedByInputs), this.elasticsearchClient, projection.primaryKeys(), projection.ids(), projection.clusteredBy(), projection.clusteredByIdent(), projection.allTargetColumns(), insertInputs, ctx.expressions(), projection.isIgnoreDuplicateKeys(), projection.onDuplicateKeyAssignments(), projection.bulkActions(), projection.autoCreateIndices(), projection.returnValues(), context.jobId, projection.fullDocSizeEstimate());
    }

    @Override
    public Projector visitFilterProjection(FilterProjection projection, Context context) {
        Predicate<Row> rowFilter = RowFilter.create(context.txnCtx, this.inputFactory, projection.query());
        return new FilterProjector(rowFilter);
    }

    @Override
    public Projector visitUpdateProjection(UpdateProjection projection, Context context) {
        this.checkShardLevel("Update projection can only be executed on a shard");
        ShardDMLExecutor<?, ?, Object, ?> shardDMLExecutor = projection.returnValues() == null ? this.buildUpdateShardDMLExecutor(context, projection, ShardDMLExecutor.ROW_COUNT_COLLECTOR) : this.buildUpdateShardDMLExecutor(context, projection, ShardDMLExecutor.RESULT_ROW_COLLECTOR);
        return new DMLProjector(shardDMLExecutor);
    }

    private <A> ShardDMLExecutor<?, ?, A, ?> buildUpdateShardDMLExecutor(Context context, UpdateProjection projection, Collector<ShardResponse, A, Iterable<Row>> collector) {
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(context.txnCtx.sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.get(this.settings), ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, projection.assignmentsColumns(), null, projection.returnValues(), context.jobId);
        return new ShardDMLExecutor<ShardUpsertRequest, ShardUpsertRequest.Item, A, Iterable<Row>>(context.jobId, 10000, this.threadPool.scheduler(), this.threadPool.executor("search"), this.resolveUidCollectExpression(context.txnCtx, projection.uidSymbol()), this.clusterService, context.ramAccounting, this.circuitBreakerService.getBreaker("query"), this.nodeJobsCounter, () -> builder.newRequest(this.shardId), id -> {
            Long requiredVersion = projection.requiredVersion();
            return ShardUpsertRequest.Item.forUpdate(id, projection.assignments(), requiredVersion == null ? -3L : requiredVersion, -2L, 0L, projection.fullDocSizeEstimate());
        }, (req, resp) -> this.elasticsearchClient.execute(ShardUpsertAction.INSTANCE, req).whenComplete((BiConsumer)resp), collector);
    }

    @Override
    public Projector visitDeleteProjection(DeleteProjection projection, Context context) {
        this.checkShardLevel("Delete projection can only be executed on a shard");
        TimeValue reqTimeout = ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.get(this.settings);
        ShardDMLExecutor<ShardDeleteRequest, ShardDeleteRequest.Item, long[], Iterable<Row>> shardDMLExecutor = new ShardDMLExecutor<ShardDeleteRequest, ShardDeleteRequest.Item, long[], Iterable<Row>>(context.jobId, 10000, this.threadPool.scheduler(), this.threadPool.executor("search"), this.resolveUidCollectExpression(context.txnCtx, projection.uidSymbol()), this.clusterService, context.ramAccounting, this.circuitBreakerService.getBreaker("query"), this.nodeJobsCounter, () -> (ShardDeleteRequest)new ShardDeleteRequest(this.shardId, context.jobId).timeout(reqTimeout), ShardDeleteRequest.Item::new, (req, resp) -> this.elasticsearchClient.execute(ShardDeleteAction.INSTANCE, req).whenComplete((BiConsumer)resp), ShardDMLExecutor.ROW_COUNT_COLLECTOR);
        return new DMLProjector(shardDMLExecutor);
    }

    private void checkShardLevel(String errorMessage) {
        if (this.shardId == null) {
            throw new UnsupportedOperationException(errorMessage);
        }
    }

    private CollectExpression<Row, ?> resolveUidCollectExpression(TransactionContext txnCtx, Symbol uidSymbol) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(txnCtx);
        ctx.add(uidSymbol);
        return (CollectExpression)Iterables.getOnlyElement(ctx.expressions());
    }

    @Override
    public Projector visitFetchProjection(FetchProjection projection, Context context) {
        return FetchProjector.create(projection, context.ramAccounting, () -> FetchProjector.computeReaderBucketsByteThreshold(this.circuitBreakerService.getBreaker("query")), context.txnCtx, this.nodeCtx, new TransportFetchOperation(req -> this.elasticsearchClient.execute(FetchNodeAction.INSTANCE, req), projection.generateStreamersGroupedByReaderAndNode(), context.jobId, projection.fetchPhaseId(), context.ramAccounting));
    }

    @Override
    public Projector visitSysUpdateProjection(SysUpdateProjection projection, Context context) {
        Map<Reference, Symbol> assignments = projection.assignments();
        assert (!assignments.isEmpty()) : "at least one assignment is required";
        ArrayList valueInputs = new ArrayList(assignments.size());
        ArrayList<ColumnIdent> assignmentCols = new ArrayList<ColumnIdent>(assignments.size());
        RelationName relationName = null;
        InputFactory.Context<?> readCtx = null;
        for (Map.Entry<Reference, Symbol> e : assignments.entrySet()) {
            Reference ref = e.getKey();
            assert (relationName == null || relationName.equals(ref.ident().tableIdent())) : "mixed table assignments found";
            relationName = ref.ident().tableIdent();
            if (readCtx == null) {
                StaticTableDefinition<?> tableDefinition = this.staticTableDefinitionGetter.apply(relationName);
                readCtx = this.inputFactory.ctxForRefs(context.txnCtx, tableDefinition.getReferenceResolver());
            }
            assignmentCols.add(ref.column());
            Input<?> sourceInput = readCtx.add(e.getValue());
            valueInputs.add(sourceInput);
        }
        SysRowUpdater<?> rowUpdater = this.sysUpdaterGetter.apply(relationName);
        assert (readCtx != null) : "readCtx must not be null";
        assert (rowUpdater != null) : "row updater needs to exist";
        Consumer<Object> rowWriter = rowUpdater.newRowWriter(assignmentCols, valueInputs, readCtx.expressions());
        if (projection.returnValues() == null) {
            return new SysUpdateProjector(rowWriter);
        }
        InputFactory.Context<SysNodeCheck> cntx = new InputFactory(this.nodeCtx).ctxForRefs(context.txnCtx, new StaticTableReferenceResolver<SysNodeCheck>(SysNodeChecksTableInfo.INSTANCE.expressions()));
        cntx.add(List.of(projection.returnValues()));
        return new SysUpdateResultSetProjector(rowUpdater, rowWriter, cntx.expressions(), cntx.topLevelInputs());
    }

    @Override
    public Projector visitProjectSet(ProjectSetProjection projectSet, Context context) {
        ArrayList<Input<Iterable<Row>>> tableFunctions = new ArrayList<Input<Iterable<Row>>>(projectSet.tableFunctions().size());
        InputFactory.Context<CollectExpression<Row, ?>> ctx = this.inputFactory.ctxForInputColumns(context.txnCtx);
        for (int i = 0; i < projectSet.tableFunctions().size(); ++i) {
            Symbol tableFunction = projectSet.tableFunctions().get(i);
            Input<?> implementation = ctx.add(tableFunction);
            tableFunctions.add(implementation);
        }
        ctx.add(projectSet.standalone());
        TableFunctionApplier tableFunctionApplier = new TableFunctionApplier(tableFunctions, ctx.topLevelInputs(), ctx.expressions());
        return new FlatMapProjector(tableFunctionApplier);
    }

    @Override
    public Projector visitWindowAgg(WindowAggProjection windowAgg, Context context) {
        ThreadPoolExecutor searchThreadPool = (ThreadPoolExecutor)this.threadPool.executor("search");
        return WindowProjector.fromProjection(windowAgg, this.nodeCtx, this.inputFactory, context.txnCtx, context.ramAccounting, context.memoryManager, this.clusterService.state().nodes().getMinNodeVersion(), this.indexVersionCreated, ThreadPools.numIdleThreads(searchThreadPool, this.numProcessors), searchThreadPool);
    }

    @Override
    public Projector visitCorrelatedJoin(CorrelatedJoinProjection correlatedJoin, Context context) {
        return new CorrelatedJoinProjector(correlatedJoin.subQueryPlan(), correlatedJoin.correlatedSubQuery(), correlatedJoin.plannerContext(), correlatedJoin.executor(), correlatedJoin.subQueryResults(), correlatedJoin.params(), correlatedJoin.inputPlanOutputs());
    }

    @Override
    public Projector create(Projection projection, TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, UUID jobId) {
        return (Projector)this.process(projection, new Context(txnCtx, ramAccounting, memoryManager, jobId));
    }

    @Override
    protected Projector visitProjection(Projection projection, Context context) {
        throw new UnsupportedOperationException("Unsupported projection");
    }

    static class Context {
        private final RamAccounting ramAccounting;
        private final MemoryManager memoryManager;
        private final UUID jobId;
        private final TransactionContext txnCtx;

        public Context(TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, UUID jobId) {
            this.txnCtx = txnCtx;
            this.ramAccounting = ramAccounting;
            this.memoryManager = memoryManager;
            this.jobId = jobId;
        }
    }
}

