/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.execution.engine.collect.CollectExpression;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;

public final class TableFunctionApplier
implements Function<Row, Iterator<Row>> {
    private final RowN outgoingRow;
    private final Object[] outgoingCells;
    private final List<Input<Iterable<Row>>> tableFunctions;
    private final List<Input<?>> standalone;
    private final List<CollectExpression<Row, ?>> expressions;

    public TableFunctionApplier(List<Input<Iterable<Row>>> tableFunctions, List<Input<?>> standalone, List<CollectExpression<Row, ?>> expressions) {
        this.tableFunctions = tableFunctions;
        this.standalone = standalone;
        this.expressions = expressions;
        this.outgoingCells = new Object[tableFunctions.size() + standalone.size()];
        this.outgoingRow = new RowN(this.outgoingCells);
    }

    @Override
    public Iterator<Row> apply(Row row) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.expressions.get(i).setNextRow(row);
        }
        this.mapIncomingValuesToOutgoingCells();
        final List iterators = Lists.map(this.tableFunctions, x -> ((Iterable)x.value()).iterator());
        return new Iterator<Row>(this){
            final /* synthetic */ TableFunctionApplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                for (int i = 0; i < iterators.size(); ++i) {
                    if (!((Iterator)iterators.get(i)).hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Iterator doesn't have any more elements");
                }
                for (int i = 0; i < iterators.size(); ++i) {
                    Iterator it = (Iterator)iterators.get(i);
                    if (it.hasNext()) {
                        Row row = (Row)it.next();
                        if (row.numColumns() == 1) {
                            this.this$0.outgoingCells[i] = row.get(0);
                            continue;
                        }
                        this.this$0.outgoingCells[i] = row;
                        continue;
                    }
                    this.this$0.outgoingCells[i] = null;
                }
                return this.this$0.outgoingRow;
            }
        };
    }

    private void mapIncomingValuesToOutgoingCells() {
        for (int i = 0; i < this.standalone.size(); ++i) {
            this.outgoingCells[this.tableFunctions.size() + i] = this.standalone.get(i).value();
        }
    }
}

