/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.data.ArrayBucket;
import io.crate.data.Bucket;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.sort.RowPriorityQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.lucene.util.ArrayUtil;

public class BoundedSortingLimitAndOffsetCollector
implements Collector<Row, RowPriorityQueue<Object[]>, Bucket> {
    private final Collection<? extends Input<?>> inputs;
    private final Iterable<? extends CollectExpression<Row, ?>> expressions;
    private final int numOutputs;
    private final Comparator<Object[]> comparator;
    private final int offset;
    private final int maxSize;
    private final RowAccounting<Object[]> rowAccounting;
    private Object[] spare;

    public BoundedSortingLimitAndOffsetCollector(RowAccounting<Object[]> rowAccounting, Collection<? extends Input<?>> inputs, Iterable<? extends CollectExpression<Row, ?>> expressions, int numOutputs, Comparator<Object[]> comparator, int limit, int offset) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid LIMIT: value must be > 0; got: " + limit);
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid OFFSET: value must be >= 0; got: " + offset);
        }
        this.rowAccounting = rowAccounting;
        this.inputs = inputs;
        this.expressions = expressions;
        this.numOutputs = numOutputs;
        this.comparator = comparator;
        this.offset = offset;
        this.maxSize = limit + offset;
        if (this.maxSize >= ArrayUtil.MAX_ARRAY_LENGTH || this.maxSize < 0) {
            throw new IllegalArgumentException("Invalid LIMIT + OFFSET: value must be <= " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + this.maxSize);
        }
    }

    @Override
    public Supplier<RowPriorityQueue<Object[]>> supplier() {
        return () -> new RowPriorityQueue<Object[]>(this.maxSize, this.comparator.reversed());
    }

    @Override
    public BiConsumer<RowPriorityQueue<Object[]>, Row> accumulator() {
        return this::onNextRow;
    }

    @Override
    public BinaryOperator<RowPriorityQueue<Object[]>> combiner() {
        return (pq1, pq2) -> {
            throw new UnsupportedOperationException("combine not supported");
        };
    }

    @Override
    public Function<RowPriorityQueue<Object[]>, Bucket> finisher() {
        return this::pqToIterable;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    private void onNextRow(RowPriorityQueue<Object[]> pq, Row row) {
        for (CollectExpression<Row, ?> expression : this.expressions) {
            expression.setNextRow(row);
        }
        boolean accountForExtraSpare = false;
        if (this.spare == null) {
            this.spare = new Object[this.inputs.size()];
            accountForExtraSpare = true;
        }
        int i = 0;
        for (Input<?> input : this.inputs) {
            this.spare[i] = input.value();
            ++i;
        }
        if (accountForExtraSpare) {
            this.rowAccounting.accountForAndMaybeBreak((Object)this.spare);
        }
        this.spare = (Object[])pq.insertWithOverflow(this.spare);
    }

    private Bucket pqToIterable(RowPriorityQueue<Object[]> pq) {
        int resultSize = Math.max(pq.size() - this.offset, 0);
        Object[][] rows = new Object[resultSize][];
        for (int i = resultSize - 1; i >= 0; --i) {
            rows[i] = (Object[])pq.pop();
        }
        return new ArrayBucket(rows, this.numOutputs);
    }
}

